/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.capability.IPlayerRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IStackRecipeData;
import top.theillusivec4.polymorph.api.common.capability.ITileEntityRecipeData;

public class RecipeSelection {
    public static <T extends IRecipe<C>, C extends IInventory> Optional<T> getPlayerRecipe(IRecipeType<T> pType, C pInventory, World pWorld, PlayerEntity pPlayer) {
        return RecipeSelection.getPlayerRecipe(pType, pInventory, pWorld, pPlayer, new ArrayList());
    }

    public static <T extends IRecipe<C>, C extends IInventory> Optional<T> getPlayerRecipe(IRecipeType<T> pType, C pInventory, World pWorld, PlayerEntity pPlayer, List<T> pRecipes) {
        LazyOptional<IPlayerRecipeData> maybeData = PolymorphApi.common().getRecipeData(pPlayer);
        return RecipeSelection.getRecipe(pType, pInventory, pWorld, maybeData, pRecipes);
    }

    public static <T extends IRecipe<C>, C extends IInventory> Optional<T> getStackRecipe(IRecipeType<T> pType, C pInventory, World pWorld, ItemStack pStack) {
        LazyOptional<IStackRecipeData> maybeData = PolymorphApi.common().getRecipeData(pStack);
        return RecipeSelection.getRecipe(pType, pInventory, pWorld, maybeData, new ArrayList());
    }

    public static <T extends IRecipe<C>, C extends IInventory> Optional<T> getTileEntityRecipe(IRecipeType<T> pType, C pInventory, World pWorld, TileEntity pTileEntity) {
        LazyOptional<ITileEntityRecipeData> maybeData = PolymorphApi.common().getRecipeData(pTileEntity);
        return RecipeSelection.getRecipe(pType, pInventory, pWorld, maybeData, new ArrayList());
    }

    private static <T extends IRecipe<C>, C extends IInventory> Optional<T> getRecipe(IRecipeType<T> pType, C pInventory, World pWorld, LazyOptional<? extends IRecipeData<?>> pOpt, List<T> pRecipes) {
        if (pOpt.isPresent()) {
            return pOpt.map(recipeData -> recipeData.getRecipe(pType, pInventory, pWorld, pRecipes)).orElse(Optional.empty());
        }
        return pWorld.func_199532_z().func_215370_b(pType, pInventory, pWorld).stream().findFirst();
    }
}

