/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.api.common.capability.IPlayerRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IStackRecipeData;
import top.theillusivec4.polymorph.api.common.capability.ITileEntityRecipeData;

public class PolymorphCapabilities {
    @CapabilityInject(value=IPlayerRecipeData.class)
    public static final Capability<IPlayerRecipeData> PLAYER_RECIPE_DATA = null;
    @CapabilityInject(value=ITileEntityRecipeData.class)
    public static final Capability<ITileEntityRecipeData> TILE_ENTITY_RECIPE_DATA = null;
    @CapabilityInject(value=IStackRecipeData.class)
    public static final Capability<IStackRecipeData> STACK_RECIPE_DATA = null;
    public static final ResourceLocation PLAYER_RECIPE_DATA_ID = new ResourceLocation("polymorph", "player_recipe_data");
    public static final ResourceLocation TILE_ENTITY_RECIPE_DATA_ID = new ResourceLocation("polymorph", "persistent_selector");
    public static final ResourceLocation STACK_RECIPE_DATA_ID = new ResourceLocation("polymorph", "stack_recipe_data");

    public static LazyOptional<IPlayerRecipeData> getRecipeData(PlayerEntity pPlayer) {
        return pPlayer.getCapability(PLAYER_RECIPE_DATA);
    }

    public static LazyOptional<ITileEntityRecipeData> getRecipeData(TileEntity pTileEntity) {
        return pTileEntity.getCapability(TILE_ENTITY_RECIPE_DATA);
    }

    public static LazyOptional<IStackRecipeData> getRecipeData(ItemStack pStack) {
        return pStack.getCapability(STACK_RECIPE_DATA);
    }

    public static void register() {
        CapabilityManager manager = CapabilityManager.INSTANCE;
        manager.register(IPlayerRecipeData.class, (Capability.IStorage)new Capability.IStorage<IPlayerRecipeData>(){

            @Nullable
            public INBT writeNBT(Capability<IPlayerRecipeData> capability, IPlayerRecipeData instance, Direction side) {
                return instance.writeNBT();
            }

            public void readNBT(Capability<IPlayerRecipeData> capability, IPlayerRecipeData instance, Direction side, INBT nbt) {
                instance.readNBT((CompoundNBT)nbt);
            }
        }, () -> new EmptyPlayerRecipeData());
        manager.register(IStackRecipeData.class, (Capability.IStorage)new Capability.IStorage<IStackRecipeData>(){

            @Nullable
            public INBT writeNBT(Capability<IStackRecipeData> capability, IStackRecipeData instance, Direction side) {
                return instance.writeNBT();
            }

            public void readNBT(Capability<IStackRecipeData> capability, IStackRecipeData instance, Direction side, INBT nbt) {
                instance.readNBT((CompoundNBT)nbt);
            }
        }, () -> new EmptyStackRecipeData());
        manager.register(ITileEntityRecipeData.class, (Capability.IStorage)new Capability.IStorage<ITileEntityRecipeData>(){

            @Nullable
            public INBT writeNBT(Capability<ITileEntityRecipeData> capability, ITileEntityRecipeData instance, Direction side) {
                return instance.writeNBT();
            }

            public void readNBT(Capability<ITileEntityRecipeData> capability, ITileEntityRecipeData instance, Direction side, INBT nbt) {
                instance.readNBT((CompoundNBT)nbt);
            }
        }, () -> new EmptyTileEntityRecipeData());
    }

    private static class EmptyRecipeData<E>
    implements IRecipeData<E> {
        private EmptyRecipeData() {
        }

        @Override
        public <T extends IRecipe<C>, C extends IInventory> Optional<T> getRecipe(IRecipeType<T> pType, C pInventory, World pWorld, List<T> pRecipes) {
            return Optional.empty();
        }

        @Override
        public Optional<? extends IRecipe<?>> getSelectedRecipe() {
            return Optional.empty();
        }

        @Override
        public void setSelectedRecipe(@Nonnull IRecipe<?> pRecipe) {
        }

        @Override
        public void selectRecipe(@Nonnull IRecipe<?> pRecipe) {
        }

        @Override
        @Nonnull
        public SortedSet<IRecipePair> getRecipesList() {
            return new TreeSet<IRecipePair>(Comparator.comparing(pair -> pair.getOutput().func_77977_a()));
        }

        @Override
        public void setRecipesList(@Nonnull SortedSet<IRecipePair> pData) {
        }

        @Override
        public boolean isEmpty(IInventory pInventory) {
            return false;
        }

        @Override
        public Set<ServerPlayerEntity> getListeners() {
            return null;
        }

        @Override
        public void sendRecipesListToListeners(boolean pEmpty) {
        }

        @Override
        public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
            return null;
        }

        @Override
        public E getOwner() {
            return null;
        }

        @Override
        public boolean isFailing() {
            return false;
        }

        @Override
        public void setFailing(boolean pFailing) {
        }

        @Override
        public CompoundNBT writeNBT() {
            return null;
        }

        @Override
        public void readNBT(CompoundNBT pCompound) {
        }
    }

    private static final class EmptyTileEntityRecipeData
    extends EmptyRecipeData<TileEntity>
    implements ITileEntityRecipeData {
        private EmptyTileEntityRecipeData() {
        }

        @Override
        public void tick() {
        }

        @Override
        public boolean isFailing() {
            return false;
        }

        @Override
        public void setFailing(boolean pFailing) {
        }

        @Override
        public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
            return null;
        }
    }

    private static final class EmptyStackRecipeData
    extends EmptyRecipeData<ItemStack>
    implements IStackRecipeData {
        private EmptyStackRecipeData() {
        }
    }

    private static final class EmptyPlayerRecipeData
    extends EmptyRecipeData<PlayerEntity>
    implements IPlayerRecipeData {
        private EmptyPlayerRecipeData() {
        }
    }
}

