/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.api.common.capability.ITileEntityRecipeData;
import top.theillusivec4.polymorph.common.capability.AbstractRecipeData;

public abstract class AbstractTileEntityRecipeData<E extends TileEntity>
extends AbstractRecipeData<TileEntity>
implements ITileEntityRecipeData {
    private NonNullList<ItemStack> lastInput = NonNullList.func_191196_a();

    public AbstractTileEntityRecipeData(E pOwner) {
        super(pOwner);
    }

    protected abstract NonNullList<ItemStack> getInput();

    @Override
    public void tick() {
        boolean changed = false;
        NonNullList<ItemStack> currentInput = this.getInput();
        this.lastInput = this.validateList(this.lastInput, currentInput.size());
        for (int i = 0; i < currentInput.size(); ++i) {
            ItemStack currentStack;
            ItemStack lastStack = (ItemStack)this.lastInput.get(i);
            if (!ItemStack.func_77989_b((ItemStack)lastStack, (ItemStack)(currentStack = (ItemStack)currentInput.get(i)))) {
                changed = true;
            }
            this.lastInput.set(i, (Object)currentStack.func_77946_l());
        }
        if (changed) {
            this.sendRecipesListToListeners(this.isFailing() || this.isEmpty());
        }
    }

    private NonNullList<ItemStack> validateList(NonNullList<ItemStack> pList, int pSize) {
        if (pList.size() == pSize) {
            return pList;
        }
        NonNullList resized = NonNullList.func_191197_a((int)pSize, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < Math.min(resized.size(), pList.size()); ++i) {
            resized.set(i, pList.get(i));
        }
        return resized;
    }

    @Override
    public Set<ServerPlayerEntity> getListeners() {
        World world = this.getOwner().func_145831_w();
        HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>();
        if (world instanceof ServerWorld) {
            for (ServerPlayerEntity player : ((ServerWorld)world).getWorldServer().func_217369_A()) {
                PolymorphApi.common().getRecipeDataFromTileEntity(player.field_71070_bA).ifPresent(recipeData -> {
                    if (recipeData == this) {
                        players.add(player);
                    }
                });
            }
        }
        return players;
    }

    @Override
    public E getOwner() {
        return (E)((TileEntity)super.getOwner());
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.getInput()) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
        return new Pair(this.getRecipesList(), null);
    }

    @Override
    public boolean isEmpty(IInventory pInventory) {
        return this.isEmpty();
    }
}

