/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.api.common.capability.IRecipeData;
import top.theillusivec4.polymorph.common.PolymorphMod;
import top.theillusivec4.polymorph.common.impl.RecipePair;

public abstract class AbstractRecipeData<E>
implements IRecipeData<E> {
    private final SortedSet<IRecipePair> recipesList = new TreeSet<IRecipePair>();
    private final E owner;
    private IRecipe<?> lastRecipe;
    private IRecipe<?> selectedRecipe;
    private ResourceLocation loadedRecipe;
    private boolean isFailing;

    public AbstractRecipeData(E pOwner) {
        this.owner = pOwner;
    }

    @Override
    public <T extends IRecipe<C>, C extends IInventory> Optional<T> getRecipe(IRecipeType<T> pType, C pInventory, World pWorld, List<T> pRecipes) {
        List recipes;
        this.getLoadedRecipe().flatMap(id -> pWorld.func_199532_z().func_215367_a(id)).ifPresent(selected -> {
            try {
                if (selected.func_222127_g() == pType && (selected.func_77569_a(pInventory, pWorld) || this.isEmpty(pInventory))) {
                    this.setSelectedRecipe((IRecipe<?>)selected);
                }
            }
            catch (ClassCastException e) {
                PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)selected.func_199560_c(), (Object)pInventory);
            }
            this.loadedRecipe = null;
        });
        if (this.isEmpty(pInventory)) {
            this.setFailing(false);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        this.getLastRecipe().ifPresent(recipe -> {
            try {
                if (recipe.func_222127_g() == pType && recipe.func_77569_a(pInventory, pWorld)) {
                    this.getSelectedRecipe().ifPresent(selected -> {
                        try {
                            if (selected.func_222127_g() == pType && selected.func_77569_a(pInventory, pWorld)) {
                                ref.set(selected);
                            }
                        }
                        catch (ClassCastException e) {
                            PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)selected.func_199560_c(), (Object)pInventory);
                        }
                    });
                }
            }
            catch (ClassCastException e) {
                PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)recipe.func_199560_c(), (Object)pInventory);
            }
        });
        IRecipe result = ref.get();
        if (result != null) {
            this.setFailing(false);
            this.sendRecipesListToListeners(false);
            return Optional.of(result);
        }
        TreeSet<IRecipePair> newDataset = new TreeSet<IRecipePair>();
        List list = recipes = pRecipes.isEmpty() ? pWorld.func_199532_z().func_215370_b(pType, pInventory, pWorld) : pRecipes;
        if (recipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        for (IRecipe entry : recipes) {
            ResourceLocation id2 = entry.func_199560_c();
            if (ref.get() == null && this.getSelectedRecipe().map(recipe -> recipe.func_199560_c().equals((Object)id2)).orElse(false).booleanValue()) {
                ref.set(entry);
            }
            newDataset.add(new RecipePair(id2, entry.func_77572_b(pInventory)));
        }
        this.setRecipesList(newDataset);
        result = ref.get();
        this.lastRecipe = result = result != null ? result : (IRecipe)recipes.get(0);
        this.setSelectedRecipe(result);
        this.setFailing(false);
        this.sendRecipesListToListeners(false);
        return Optional.of(result);
    }

    @Override
    public Optional<? extends IRecipe<?>> getSelectedRecipe() {
        return Optional.ofNullable(this.selectedRecipe);
    }

    @Override
    public void setSelectedRecipe(@Nonnull IRecipe<?> pRecipe) {
        this.selectedRecipe = pRecipe;
    }

    public Optional<? extends IRecipe<?>> getLastRecipe() {
        return Optional.ofNullable(this.lastRecipe);
    }

    public Optional<ResourceLocation> getLoadedRecipe() {
        return Optional.ofNullable(this.loadedRecipe);
    }

    @Override
    @Nonnull
    public SortedSet<IRecipePair> getRecipesList() {
        return this.recipesList;
    }

    @Override
    public void setRecipesList(@Nonnull SortedSet<IRecipePair> pData) {
        this.recipesList.clear();
        this.recipesList.addAll(pData);
    }

    @Override
    public boolean isEmpty(IInventory pInventory) {
        if (pInventory != null) {
            for (int i = 0; i < pInventory.func_70302_i_(); ++i) {
                if (pInventory.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public E getOwner() {
        return this.owner;
    }

    @Override
    public void selectRecipe(@Nonnull IRecipe<?> pRecipe) {
        this.setSelectedRecipe(pRecipe);
    }

    @Override
    public abstract Set<ServerPlayerEntity> getListeners();

    @Override
    public void sendRecipesListToListeners(boolean pEmpty) {
        Pair packetData = pEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
        for (ServerPlayerEntity listener : this.getListeners()) {
            PolymorphApi.common().getPacketDistributor().sendRecipesListS2C(listener, (SortedSet)packetData.getFirst(), (ResourceLocation)packetData.getSecond());
        }
    }

    @Override
    public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
        return new Pair(this.getRecipesList(), null);
    }

    @Override
    public boolean isFailing() {
        return this.isFailing;
    }

    @Override
    public void setFailing(boolean pFailing) {
        this.isFailing = pFailing;
    }

    @Override
    public void readNBT(CompoundNBT pCompound) {
        if (pCompound.func_74764_b("SelectedRecipe")) {
            this.loadedRecipe = new ResourceLocation(pCompound.func_74779_i("SelectedRecipe"));
        }
        if (pCompound.func_74764_b("RecipeDataSet")) {
            SortedSet<IRecipePair> dataset = this.getRecipesList();
            dataset.clear();
            ListNBT list = pCompound.func_150295_c("RecipeDataSet", 10);
            for (INBT inbt : list) {
                CompoundNBT tag = (CompoundNBT)inbt;
                ResourceLocation id = ResourceLocation.func_208304_a((String)tag.func_74779_i("Id"));
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("ItemStack"));
                dataset.add(new RecipePair(id, stack));
            }
        }
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        this.getSelectedRecipe().ifPresent(selected -> nbt.func_74778_a("SelectedRecipe", this.selectedRecipe.func_199560_c().toString()));
        SortedSet<IRecipePair> dataset = this.getRecipesList();
        if (!dataset.isEmpty()) {
            ListNBT list = new ListNBT();
            for (IRecipePair data : dataset) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_218657_a("ItemStack", (INBT)data.getOutput().func_77955_b(new CompoundNBT()));
                tag.func_74778_a("Id", data.getResourceLocation().toString());
                list.add((Object)tag);
            }
            nbt.func_218657_a("RecipeDataSet", (INBT)list);
        }
        return nbt;
    }
}

