/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.api.common.base.IPolymorphPacketDistributor;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.api.common.capability.IPlayerRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IStackRecipeData;
import top.theillusivec4.polymorph.api.common.capability.ITileEntityRecipeData;
import top.theillusivec4.polymorph.common.capability.PlayerRecipeData;
import top.theillusivec4.polymorph.common.capability.PolymorphCapabilities;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;

public class CommonEventsListener {
    private static final Map<TileEntity, ITileEntityRecipeData> TICKABLE_TILES = new ConcurrentHashMap<TileEntity, ITileEntityRecipeData>();

    @SubscribeEvent
    public void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        PolymorphApi.common().setServer(evt.getServer());
        TICKABLE_TILES.clear();
    }

    @SubscribeEvent
    public void serverStopped(FMLServerStoppedEvent evt) {
        PolymorphApi.common().setServer(null);
        TICKABLE_TILES.clear();
    }

    @SubscribeEvent
    public void openContainer(PlayerContainerEvent.Open pEvent) {
        PlayerEntity player = pEvent.getPlayer();
        if (!player.field_70170_p.func_201670_d() && player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            Container container = pEvent.getContainer();
            IPolymorphCommon commonApi = PolymorphApi.common();
            commonApi.getRecipeDataFromTileEntity(container).ifPresent(recipeData -> {
                IPolymorphPacketDistributor packetDistributor = commonApi.getPacketDistributor();
                if (recipeData.isFailing() || recipeData.isEmpty(null)) {
                    packetDistributor.sendRecipesListS2C(serverPlayerEntity);
                } else {
                    Pair<SortedSet<IRecipePair>, ResourceLocation> data = recipeData.getPacketData();
                    packetDistributor.sendRecipesListS2C(serverPlayerEntity, (SortedSet)data.getFirst(), (ResourceLocation)data.getSecond());
                }
            });
            for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
                if (!integration.openContainer(container, serverPlayerEntity)) continue;
                return;
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent evt) {
        World world = evt.world;
        if (!world.func_201670_d() && evt.phase == TickEvent.Phase.END) {
            IPolymorphCommon commonApi = PolymorphApi.common();
            ArrayList<TileEntity> toRemove = new ArrayList<TileEntity>();
            for (Map.Entry<TileEntity, ITileEntityRecipeData> entry : TICKABLE_TILES.entrySet()) {
                TileEntity te = entry.getKey();
                World teWorld = te.func_145831_w();
                if (te.func_145837_r() || teWorld == null || teWorld.func_201670_d()) {
                    toRemove.add(te);
                    continue;
                }
                entry.getValue().tick();
            }
            for (TileEntity te : toRemove) {
                TICKABLE_TILES.remove(te);
            }
        }
    }

    @SubscribeEvent
    public void attachCapabilitiesTileEntity(AttachCapabilitiesEvent<TileEntity> pEvent) {
        TileEntity te = (TileEntity)pEvent.getObject();
        PolymorphApi.common().tryCreateRecipeData(te).ifPresent(recipeData -> {
            pEvent.addCapability(PolymorphCapabilities.TILE_ENTITY_RECIPE_DATA_ID, (ICapabilityProvider)new TileEntityRecipeDataProvider((ITileEntityRecipeData)recipeData));
            TICKABLE_TILES.put(te, (ITileEntityRecipeData)recipeData);
            pEvent.addListener(() -> TICKABLE_TILES.remove(te));
        });
    }

    @SubscribeEvent
    public void attachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> pEvent) {
        Entity entity = (Entity)pEvent.getObject();
        if (entity instanceof PlayerEntity) {
            PlayerRecipeData data = new PlayerRecipeData((PlayerEntity)entity);
            pEvent.addCapability(PolymorphCapabilities.PLAYER_RECIPE_DATA_ID, (ICapabilityProvider)new PlayerRecipeDataProvider(data));
        }
    }

    @SubscribeEvent
    public void attachCapabilitiesStack(AttachCapabilitiesEvent<ItemStack> pEvent) {
        ItemStack stack = (ItemStack)pEvent.getObject();
        PolymorphApi.common().tryCreateRecipeData(stack).ifPresent(recipeData -> pEvent.addCapability(PolymorphCapabilities.STACK_RECIPE_DATA_ID, (ICapabilityProvider)new StackRecipeDataProvider((IStackRecipeData)recipeData)));
    }

    private static class TileEntityRecipeDataProvider
    implements ICapabilitySerializable<INBT> {
        final ITileEntityRecipeData recipeData;
        final LazyOptional<ITileEntityRecipeData> capability;

        public TileEntityRecipeDataProvider(ITileEntityRecipeData pRecipeData) {
            this.recipeData = pRecipeData;
            this.capability = LazyOptional.of(() -> this.recipeData);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> pCapability, @Nullable Direction pDirection) {
            return PolymorphCapabilities.TILE_ENTITY_RECIPE_DATA.orEmpty(pCapability, this.capability);
        }

        public INBT serializeNBT() {
            return PolymorphCapabilities.TILE_ENTITY_RECIPE_DATA.writeNBT((Object)this.recipeData, null);
        }

        public void deserializeNBT(INBT pNbt) {
            PolymorphCapabilities.TILE_ENTITY_RECIPE_DATA.readNBT((Object)this.recipeData, null, pNbt);
        }
    }

    private static class PlayerRecipeDataProvider
    implements ICapabilitySerializable<INBT> {
        final IPlayerRecipeData recipeData;
        final LazyOptional<IPlayerRecipeData> capability;

        public PlayerRecipeDataProvider(IPlayerRecipeData pRecipeData) {
            this.recipeData = pRecipeData;
            this.capability = LazyOptional.of(() -> this.recipeData);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> pCapability, @Nullable Direction pDirection) {
            return PolymorphCapabilities.PLAYER_RECIPE_DATA.orEmpty(pCapability, this.capability);
        }

        public INBT serializeNBT() {
            return PolymorphCapabilities.PLAYER_RECIPE_DATA.writeNBT((Object)this.recipeData, null);
        }

        public void deserializeNBT(INBT pNbt) {
            PolymorphCapabilities.PLAYER_RECIPE_DATA.readNBT((Object)this.recipeData, null, pNbt);
        }
    }

    private static class StackRecipeDataProvider
    implements ICapabilitySerializable<INBT> {
        final IStackRecipeData recipeData;
        final LazyOptional<IStackRecipeData> capability;

        public StackRecipeDataProvider(IStackRecipeData pRecipeData) {
            this.recipeData = pRecipeData;
            this.capability = LazyOptional.of(() -> this.recipeData);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> pCapability, @Nullable Direction pDirection) {
            return PolymorphCapabilities.STACK_RECIPE_DATA.orEmpty(pCapability, this.capability);
        }

        public INBT serializeNBT() {
            return PolymorphCapabilities.STACK_RECIPE_DATA.writeNBT((Object)this.recipeData, null);
        }

        public void deserializeNBT(INBT pNbt) {
            PolymorphCapabilities.STACK_RECIPE_DATA.readNBT((Object)this.recipeData, null, pNbt);
        }
    }
}

