/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.content.core.TileEntityCropBase;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.QuadCache;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class AgriPlantModelBridge
implements IBakedModel,
IRenderUtilities,
Function<RenderMaterial, TextureAtlasSprite> {
    private final IModelConfiguration config;
    private final QuadTransformer transformer;
    private final ItemOverrideList overrides;
    private final Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
    private static final Map<IAgriPlant, Map<IAgriGrowthStage, QuadCache>> plantQuads = Maps.newConcurrentMap();
    private static final Map<IAgriWeed, Map<IAgriGrowthStage, QuadCache>> weedQuads = Maps.newConcurrentMap();

    protected AgriPlantModelBridge(IModelConfiguration config, ItemOverrideList overrides, Function<RenderMaterial, TextureAtlasSprite> spriteGetter) {
        this.config = config;
        this.transformer = new QuadTransformer(this.getModelConfig().getCombinedTransform().func_225615_b_());
        this.overrides = overrides;
        this.spriteGetter = spriteGetter;
    }

    public static List<BakedQuad> getOrBakeQuads(IAgriPlant plant, IAgriGrowthStage stage, @Nullable Direction face) {
        return plantQuads.computeIfAbsent(plant, aPlant -> Maps.newConcurrentMap()).computeIfAbsent(stage, aStage -> new QuadCache(dir -> plant.bakeQuads((Direction)dir, stage))).getQuads(face);
    }

    public static List<BakedQuad> getOrBakeQuads(IAgriWeed weed, IAgriGrowthStage stage, @Nullable Direction face) {
        return weedQuads.computeIfAbsent(weed, aPlant -> Maps.newConcurrentMap()).computeIfAbsent(stage, aStage -> new QuadCache(dir -> weed.bakeQuads((Direction)dir, stage))).getQuads(face);
    }

    protected IModelConfiguration getModelConfig() {
        return this.config;
    }

    protected QuadTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public TextureAtlasSprite apply(RenderMaterial renderMaterial) {
        return this.spriteGetter.apply(renderMaterial);
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return ImmutableList.of();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        ImmutableList.Builder quads = new ImmutableList.Builder();
        if (data.hasProperty(TileEntityCropBase.PROPERTY_PLANT) && data.hasProperty(TileEntityCropBase.PROPERTY_PLANT_GROWTH)) {
            quads.addAll(AgriPlantModelBridge.getOrBakeQuads((IAgriPlant)data.getData(TileEntityCropBase.PROPERTY_PLANT), (IAgriGrowthStage)data.getData(TileEntityCropBase.PROPERTY_PLANT_GROWTH), side));
        }
        if (data.hasProperty(TileEntityCropBase.PROPERTY_WEED) && data.hasProperty(TileEntityCropBase.PROPERTY_WEED_GROWTH)) {
            quads.addAll(AgriPlantModelBridge.getOrBakeQuads((IAgriWeed)data.getData(TileEntityCropBase.PROPERTY_WEED), (IAgriGrowthStage)data.getData(TileEntityCropBase.PROPERTY_WEED_GROWTH), side));
        }
        return quads.build();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData data) {
        AgriApi.getCrop((IBlockReader)world, pos).ifPresent(crop -> {
            data.setData(TileEntityCropBase.PROPERTY_PLANT, (Object)crop.getPlant());
            data.setData(TileEntityCropBase.PROPERTY_PLANT_GROWTH, (Object)crop.getGrowthStage());
            data.setData(TileEntityCropBase.PROPERTY_WEED, (Object)crop.getWeeds());
            data.setData(TileEntityCropBase.PROPERTY_WEED_GROWTH, (Object)crop.getWeedGrowthStage());
        });
        return data;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.getMissingSprite();
    }

    @Nonnull
    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        IAgriWeed weed;
        IAgriPlant plant;
        if (data.hasProperty(TileEntityCropBase.PROPERTY_PLANT) && data.hasProperty(TileEntityCropBase.PROPERTY_PLANT_GROWTH) && (plant = (IAgriPlant)data.getData(TileEntityCropBase.PROPERTY_PLANT)) != null) {
            return this.getSprite(plant.getTexturesFor((IAgriGrowthStage)data.getData(TileEntityCropBase.PROPERTY_PLANT_GROWTH)).get(0));
        }
        if (data.hasProperty(TileEntityCropBase.PROPERTY_WEED) && data.hasProperty(TileEntityCropBase.PROPERTY_WEED_GROWTH) && (weed = (IAgriWeed)data.getData(TileEntityCropBase.PROPERTY_WEED)) != null) {
            return this.getSprite(weed.getTexturesFor((IAgriGrowthStage)data.getData(TileEntityCropBase.PROPERTY_WEED_GROWTH)).get(0));
        }
        return this.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }
}

