/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal.page;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.render.items.journal.PageRenderer;
import com.infinityraider.agricraft.render.items.journal.page.BasePage;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.item.ItemStack;

public final class MutationPage
extends BasePage {
    public static final int LIMIT = 18;
    private final List<List<IAgriPlant>> mutationsLeft;
    private final List<List<IAgriPlant>> mutationsRight;

    public MutationPage(List<List<IAgriPlant>> mutations) {
        int count = mutations.size();
        if (count <= 9) {
            this.mutationsLeft = mutations;
            this.mutationsRight = ImmutableList.of();
        } else {
            this.mutationsLeft = mutations.subList(0, 8);
            this.mutationsRight = mutations.subList(9, count - 1);
        }
    }

    @Override
    public void drawLeftSheet(PageRenderer renderer, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        int posX = 10;
        int posY = 6;
        int dy = 20;
        for (List<IAgriPlant> plants : this.mutationsLeft) {
            this.drawMutation(renderer, transforms, posX, posY, plants);
            posY += dy;
        }
    }

    @Override
    public void drawRightSheet(PageRenderer renderer, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        int posX = 10;
        int posY = 6;
        int dy = 20;
        for (List<IAgriPlant> plants : this.mutationsRight) {
            this.drawMutation(renderer, transforms, posX, posY, plants);
            posY += dy;
        }
    }
}

