/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal.page;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.stats.AgriStatRegistry;
import com.infinityraider.agricraft.render.items.journal.PageRenderer;
import com.infinityraider.agricraft.render.items.journal.page.BasePage;
import com.infinityraider.agricraft.render.items.journal.page.Page;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class IntroductionPages
extends BasePage {
    public static final Page INTRODUCTION = new Introduction();
    public static final Page GENETICS = new Genetics();
    public static final Page GROWTH_REQS = new GrowthReqs();
    public static final Page[] PAGES = new Page[]{INTRODUCTION, GENETICS, GROWTH_REQS};

    private static final class GrowthReqs
    extends IntroductionPages {
        private final ITextComponent GROWTH_REQS = new TranslationTextComponent("agricraft.journal.growth_reqs");
        private final ITextComponent PARAGRAPH_L_1 = new TranslationTextComponent("agricraft.journal.growth_reqs.paragraph_1");
        private final ITextComponent BRIGHTNESS = new TranslationTextComponent("agricraft.journal.growth_reqs.brightness");
        private final ITextComponent PARAGRAPH_BRIGHTNESS = new TranslationTextComponent("agricraft.journal.growth_reqs.brightness.desc");
        private final ITextComponent HUMIDITY = new TranslationTextComponent("agricraft.journal.growth_reqs.humidity");
        private final ITextComponent PARAGRAPH_HUMIDITY = new TranslationTextComponent("agricraft.journal.growth_reqs.humidity.desc");
        private final ITextComponent ACIDITY = new TranslationTextComponent("agricraft.journal.growth_reqs.acidity");
        private final ITextComponent PARAGRAPH_ACIDITY = new TranslationTextComponent("agricraft.journal.growth_reqs.acidity.desc");
        private final ITextComponent NUTRIENTS = new TranslationTextComponent("agricraft.journal.growth_reqs.nutrients");
        private final ITextComponent PARAGRAPH_NUTRIENTS = new TranslationTextComponent("agricraft.journal.growth_reqs.nutrients.desc");
        private final ITextComponent SEASONS = new TranslationTextComponent("agricraft.journal.growth_reqs.seasons");
        private final ITextComponent PARAGRAPH_SEASONS = new TranslationTextComponent("agricraft.journal.growth_reqs.seasons.desc");

        private GrowthReqs() {
        }

        @Override
        public void drawLeftSheet(PageRenderer renderer, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
            float dy = 10.0f;
            float dx = 6.0f;
            float spacing = 4.0f;
            dy += renderer.drawText(transforms, this.GROWTH_REQS, dx, dy);
            dy += spacing;
            dy += renderer.drawText(transforms, this.PARAGRAPH_L_1, dx, dy, 0.65f);
            dy += spacing;
            dy += renderer.drawText(transforms, this.BRIGHTNESS, dx, dy, 0.65f);
            renderer.drawTexture(transforms, BasePage.Textures.BRIGHTNESS_BAR, 6.0f, dy, 66.0f, 8.0f);
            dy += 6.0f + spacing;
            dy += renderer.drawText(transforms, this.PARAGRAPH_BRIGHTNESS, dx, dy, 0.5f);
            dy += spacing;
            dy += renderer.drawText(transforms, this.HUMIDITY, dx, dy, 0.65f);
            dy += renderer.drawText(transforms, this.PARAGRAPH_HUMIDITY, dx, dy, 0.5f);
            this.drawSoilProperties(renderer, transforms, dx, dy, spacing, IAgriSoil.Humidity.values(), BasePage.Textures.HUMIDITY_OFFSETS, BasePage.Textures.HUMIDITY_FILLED);
        }

        @Override
        public void drawRightSheet(PageRenderer renderer, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
            float dy = 10.0f;
            float dx = 6.0f;
            float spacing = 4.0f;
            dy += renderer.drawText(transforms, this.ACIDITY, dx, dy, 0.65f);
            dy += renderer.drawText(transforms, this.PARAGRAPH_ACIDITY, dx, dy, 0.5f);
            dy = this.drawSoilProperties(renderer, transforms, dx, dy, spacing, IAgriSoil.Acidity.values(), BasePage.Textures.ACIDITY_OFFSETS, BasePage.Textures.ACIDITY_FILLED);
            dy += renderer.drawText(transforms, this.NUTRIENTS, dx, dy, 0.65f);
            dy += renderer.drawText(transforms, this.PARAGRAPH_NUTRIENTS, dx, dy, 0.5f);
            dy = this.drawSoilProperties(renderer, transforms, dx, dy, spacing, IAgriSoil.Nutrients.values(), BasePage.Textures.NUTRIENTS_OFFSETS, BasePage.Textures.NUTRIENTS_FILLED);
            if (AgriApi.getSeasonLogic().isActive()) {
                dy += renderer.drawText(transforms, this.SEASONS, dx, dy, 0.65f);
                dy += renderer.drawText(transforms, this.PARAGRAPH_SEASONS, dx, dy, 0.5f);
                float scale = 0.5f;
                dy += spacing * scale;
                for (int i = 0; i < AgriSeason.values().length - 1; ++i) {
                    int w = 10;
                    int h = 12;
                    float v1 = (0.0f + (float)(i * h)) / 48.0f;
                    float v2 = (0.0f + (float)((i + 1) * h)) / 48.0f;
                    renderer.drawTexture(transforms, BasePage.Textures.SEASONS_FILLED, dx, dy - spacing / 2.0f, scale * (float)w, scale * (float)h, 0.0f, v1, 1.0f, v2);
                    dy += renderer.drawText(transforms, (ITextComponent)AgriSeason.values()[i].getDisplayName(), dx + 6.0f, dy, 0.5f);
                    dy += spacing / 2.0f;
                }
            }
        }

        protected float drawSoilProperties(PageRenderer renderer, MatrixStack transforms, float dx, float dy, float spacing, IAgriSoil.SoilProperty[] property, int[] offsets, ResourceLocation texture) {
            float scale = 0.5f;
            dy += spacing * scale;
            for (int i = 0; i < property.length - 1; ++i) {
                int w = offsets[i + 1] - offsets[i];
                float u1 = ((float)offsets[i] + 0.0f) / 53.0f;
                float u2 = ((float)(offsets[i] + w) + 0.0f) / 53.0f;
                renderer.drawTexture(transforms, texture, dx, dy - spacing / 2.0f, scale * (float)w, scale * 12.0f, u1, 0.0f, u2, 1.0f);
                dy += renderer.drawText(transforms, property[i].getDescription(), dx + 6.0f, dy, 0.5f);
                dy += spacing / 2.0f;
            }
            return dy + spacing;
        }
    }

    private static final class Genetics
    extends IntroductionPages {
        private final ITextComponent CROP_BREEDING = new TranslationTextComponent("agricraft.journal.crop_breeding");
        private final ITextComponent PARAGRAPH_L_1 = new TranslationTextComponent("agricraft.journal.crop_breeding.paragraph_1");
        private final ITextComponent PARAGRAPH_L_2 = new TranslationTextComponent("agricraft.journal.crop_breeding.paragraph_2");
        private final ITextComponent PARAGRAPH_L_3 = new TranslationTextComponent("agricraft.journal.crop_breeding.paragraph_3");
        private final ResourceLocation DNA_SCHEMATIC = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/dna_schematic.png");
        private final ITextComponent STATS = new TranslationTextComponent("agricraft.journal.stats");
        private final ITextComponent PARAGRAPH_R_1 = new TranslationTextComponent("agricraft.journal.stats.paragraph_1");
        private final ITextComponent PARAGRAPH_GROWTH = new TranslationTextComponent("agricraft.journal.stats.growth");
        private final ITextComponent PARAGRAPH_GAIN = new TranslationTextComponent("agricraft.journal.stats.gain");
        private final ITextComponent PARAGRAPH_STRENGTH = new TranslationTextComponent("agricraft.journal.stats.strength");
        private final ITextComponent PARAGRAPH_RESISTANCE = new TranslationTextComponent("agricraft.journal.stats.resistance");
        private final ITextComponent PARAGRAPH_FERTILITY = new TranslationTextComponent("agricraft.journal.stats.fertility");
        private final ITextComponent PARAGRAPH_MUTATIVITY = new TranslationTextComponent("agricraft.journal.stats.mutativity");

        private Genetics() {
        }

        @Override
        public void drawLeftSheet(PageRenderer renderer, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
            float dy = 10.0f;
            float dx = 6.0f;
            float spacing = 4.0f;
            dy += renderer.drawText(transforms, this.CROP_BREEDING, dx, dy);
            dy += spacing;
            dy += renderer.drawText(transforms, this.PARAGRAPH_L_1, dx, dy, 0.65f);
            dy += spacing;
            dy += renderer.drawText(transforms, this.PARAGRAPH_L_2, dx, dy, 0.65f);
            renderer.drawTexture(transforms, this.DNA_SCHEMATIC, dx, dy += spacing, 96.0f, 32.0f);
            renderer.drawText(transforms, this.PARAGRAPH_L_3, dx, dy += spacing + 32.0f, 0.65f);
        }

        @Override
        public void drawRightSheet(PageRenderer renderer, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
            float dy = 10.0f;
            float dx = 6.0f;
            float spacing = 4.0f;
            dy += renderer.drawText(transforms, this.STATS, dx, dy);
            dy += spacing;
            dy += renderer.drawText(transforms, this.PARAGRAPH_R_1, dx, dy, 0.65f);
            dy += spacing;
            if (!((Config)AgriCraft.instance.getConfig()).isGrowthStatHidden()) {
                dy += renderer.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().growthStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
                dy += renderer.drawText(transforms, this.PARAGRAPH_GROWTH, dx, dy, 0.5f);
                dy += spacing;
            }
            if (!((Config)AgriCraft.instance.getConfig()).isGainStatHidden()) {
                dy += renderer.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().gainStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
                dy += renderer.drawText(transforms, this.PARAGRAPH_GAIN, dx, dy, 0.5f);
                dy += spacing;
            }
            if (!((Config)AgriCraft.instance.getConfig()).isStrengthStatHidden()) {
                dy += renderer.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().strengthStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
                dy += renderer.drawText(transforms, this.PARAGRAPH_STRENGTH, dx, dy, 0.5f);
                dy += spacing;
            }
            if (!((Config)AgriCraft.instance.getConfig()).isResistanceStatHidden()) {
                dy += renderer.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().resistanceStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
                dy += renderer.drawText(transforms, this.PARAGRAPH_RESISTANCE, dx, dy, 0.5f);
                dy += spacing;
            }
            if (!((Config)AgriCraft.instance.getConfig()).isFertilityStatHidden()) {
                dy += renderer.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().fertilityStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
                dy += renderer.drawText(transforms, this.PARAGRAPH_FERTILITY, dx, dy, 0.5f);
                dy += spacing;
            }
            if (!((Config)AgriCraft.instance.getConfig()).isMutativityStatHidden()) {
                dy += renderer.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().mutativityStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
                renderer.drawText(transforms, this.PARAGRAPH_MUTATIVITY, dx, dy, 0.5f);
            }
        }
    }

    private static final class Introduction
    extends IntroductionPages {
        private final ITextComponent INTRODUCTION = new TranslationTextComponent("agricraft.journal.introduction");
        private final ITextComponent PARAGRAPH_1 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_1");
        private final ITextComponent PARAGRAPH_2 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_2");
        private final ITextComponent PARAGRAPH_3 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_3");
        private final ITextComponent DISCOVERED = new TranslationTextComponent("agricraft.journal.introduction.discovered");

        private Introduction() {
        }

        @Override
        public void drawLeftSheet(PageRenderer renderer, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        }

        @Override
        public void drawRightSheet(PageRenderer renderer, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
            float dy = 10.0f;
            float dx = 6.0f;
            float spacing = 4.0f;
            dy += renderer.drawText(transforms, this.INTRODUCTION, dx, dy);
            dy += spacing;
            dy += renderer.drawText(transforms, this.PARAGRAPH_1, dx, dy, 0.7f);
            dy += spacing;
            dy += renderer.drawText(transforms, this.PARAGRAPH_2, dx, dy, 0.7f);
            dy += spacing;
            dy += renderer.drawText(transforms, this.PARAGRAPH_3, dx, dy, 0.7f);
            dy += spacing;
            IFormattableTextComponent discovered = new StringTextComponent("").func_230529_a_(this.DISCOVERED).func_240702_b_(": " + journal.getDiscoveredSeeds(stack).size() + " / " + AgriApi.getPlantRegistry().count());
            renderer.drawText(transforms, (ITextComponent)discovered, dx, dy += spacing, 0.7f);
        }
    }
}

