/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.render.items.journal.page.FrontPage;
import com.infinityraider.agricraft.render.items.journal.page.IntroductionPages;
import com.infinityraider.agricraft.render.items.journal.page.MutationPage;
import com.infinityraider.agricraft.render.items.journal.page.Page;
import com.infinityraider.agricraft.render.items.journal.page.PlantPage;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class JournalData {
    private static final int FLIPPING_DURATION = 20;
    private final ItemStack journal;
    private final List<Page> pages;
    private int page;
    private int target;
    private int animationCounter;
    private int prevAnimationCounter;

    public JournalData(ItemStack journalStack) {
        this.journal = journalStack;
        this.pages = JournalData.initializePages(journalStack);
    }

    public ItemStack getJournal() {
        return this.journal;
    }

    public Page getCurrentPage() {
        if (this.target >= this.page) {
            return this.pages.get(this.page);
        }
        return this.pages.get(this.page - 1);
    }

    public Page getFlippedPage() {
        if (this.target > this.page) {
            return this.pages.get(this.page + 1);
        }
        return this.pages.get(this.page);
    }

    public void incrementPage() {
        this.target = Math.min(this.pages.size() - 1, this.target + 1);
    }

    public void decrementPage() {
        this.target = Math.max(0, this.target - 1);
    }

    public void tick() {
        this.prevAnimationCounter = this.animationCounter;
        if (this.target > this.page) {
            if (this.animationCounter == 0) {
                this.prevAnimationCounter = this.animationCounter = 20;
            }
            --this.animationCounter;
            if (this.animationCounter <= 0) {
                this.animationCounter = 0;
                ++this.page;
                this.pages.get(this.page).onPageOpened();
            }
        } else if (this.target < this.page) {
            if (this.animationCounter == 0) {
                this.prevAnimationCounter = this.animationCounter = -20;
            }
            ++this.animationCounter;
            if (this.animationCounter >= 0) {
                this.animationCounter = 0;
                --this.page;
                this.pages.get(this.page).onPageOpened();
            }
        }
    }

    public float getFlippingProgress(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevAnimationCounter, (float)this.animationCounter) / 20.0f;
    }

    public static List<Page> initializePages(ItemStack journal) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)FrontPage.INSTANCE);
        builder.add((Object[])IntroductionPages.PAGES);
        if (journal.func_77973_b() instanceof IAgriJournalItem) {
            IAgriJournalItem journalItem = (IAgriJournalItem)journal.func_77973_b();
            builder.addAll(JournalData.getPlantPages(journalItem.getDiscoveredSeeds(journal).stream().sorted(Comparator.comparing(plant -> plant.getPlantName().getString())).collect(Collectors.toList())));
        }
        return builder.build();
    }

    public static List<Page> getPlantPages(List<IAgriPlant> plants) {
        ImmutableList.Builder pages = ImmutableList.builder();
        plants.forEach(plant -> {
            PlantPage page = new PlantPage((IAgriPlant)plant, plants);
            pages.add((Object)page);
            List<List<IAgriPlant>> mutations = page.getOffPageMutations();
            int size = mutations.size();
            if (size > 0) {
                int remaining = size;
                int from = 0;
                int to = Math.min(remaining, 18);
                while (remaining > 0) {
                    pages.add((Object)new MutationPage(mutations.subList(from, to)));
                    from = to;
                    to = from + Math.min(remaining -= to - from, 18);
                }
            }
        });
        return pages.build();
    }
}

