/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.theoneprobe;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.reference.AgriToolTips;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

final class AgriProbeCropBlockInfoProvider
implements IProbeInfoProvider {
    private final String id = AgriCraft.instance.getModId() + ":" + "theoneprobe" + "_crop";

    protected AgriProbeCropBlockInfoProvider() {
    }

    public String getID() {
        return this.id;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World world, BlockState state, IProbeHitData hitData) {
        this.addCropProbeInfo(info, player, world, hitData.getPos(), mode);
        this.addSoilProbeInfo(info, world, hitData.getPos());
    }

    protected void addCropProbeInfo(IProbeInfo info, PlayerEntity player, World world, BlockPos pos, ProbeMode mode) {
        AgriApi.getCrop((IBlockReader)world, pos).ifPresent(crop -> {
            if (mode == ProbeMode.DEBUG) {
                crop.addDisplayInfo(arg_0 -> ((IProbeInfo)info).text(arg_0));
                info.text(AgriToolTips.GENOME);
                crop.getGenome().map(genome -> {
                    genome.addDisplayInfo(arg_0 -> ((IProbeInfo)info).text(arg_0));
                    return true;
                }).orElseGet(() -> {
                    info.text((ITextComponent)AgriToolTips.UNKNOWN);
                    return false;
                });
            } else if (this.shouldAddInfo(player)) {
                crop.addDisplayInfo(arg_0 -> ((IProbeInfo)info).text(arg_0));
            }
        });
    }

    protected boolean shouldAddInfo(PlayerEntity player) {
        if (((Config)AgriCraft.instance.getConfig()).doesMagnifyingGlassControlTOP()) {
            return ((IProxy)AgriCraft.instance.proxy()).isMagnifyingGlassObserving(player);
        }
        return true;
    }

    protected void addSoilProbeInfo(IProbeInfo info, World world, BlockPos pos) {
        AgriApi.getSoil((IBlockReader)world, pos).ifPresent(soil -> soil.addDisplayInfo(arg_0 -> ((IProbeInfo)info).text(arg_0)));
    }
}

