/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.mysticalagriculture;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.client.AgriPlantRenderType;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedItem;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.content.AgriItemRegistry;
import com.infinityraider.agricraft.plugins.mysticalagriculture.MysticalAgriculturePlantSubstitutor;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.render.plant.AgriPlantQuadGenerator;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class MysticalAgricultureCompatClient {
    public static void init() {
        MysticalAgricultureCompatClient.registerEventHandler();
        MysticalAgricultureCompatClient.createPlantRenderType();
        MysticalAgricultureCompatClient.registerItemColors();
    }

    private static void registerEventHandler() {
        ((IProxy)AgriCraft.instance.proxy()).registerEventHandler(MysticalAgriculturePlantSubstitutor.getInstance());
    }

    private static void createPlantRenderType() {
        AgriPlantRenderType.create("MYSTICAL_AGRICULTURE", AgriPlantRenderType.Identifiers.predicate((List<String>)ImmutableList.of((Object)"mysticalagriculture", (Object)"mystical_agriculture")), MysticalAgricultureCompatClient::bakeQuadsForMystical);
    }

    @Nonnull
    private static List<BakedQuad> bakeQuadsForMystical(IAgriGrowable growable, IAgriGrowthStage stage, @Nullable Direction face, IntFunction<TextureAtlasSprite> spriteFunc) {
        if (face != null) {
            return ImmutableList.of();
        }
        ITessellator tessellator = AgriPlantQuadGenerator.getInstance().getTessellator();
        TextureAtlasSprite sprite = spriteFunc.apply(0);
        tessellator.startDrawingQuads();
        tessellator.setFace((Direction)null);
        tessellator.pushMatrix();
        tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.NORTH, sprite, 4.001f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.NORTH, sprite, 3.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.EAST, sprite, 4.001f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.EAST, sprite, 3.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.NORTH, sprite, 12.001f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.NORTH, sprite, 11.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.EAST, sprite, 12.001f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.EAST, sprite, 11.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        if (stage.isFinal()) {
            IAgriPlant plant = (IAgriPlant)growable;
            int flowerColor = MysticalAgricultureCompatClient.colorForFlower(plant.getId());
            TextureAtlasSprite flowerSprite = spriteFunc.apply(1);
            if (flowerColor != -1) {
                tessellator.setColorRGB((float)(flowerColor >> 16 & 0xFF) / 255.0f, (float)(flowerColor >> 8 & 0xFF) / 255.0f, (float)(flowerColor & 0xFF) / 255.0f);
            }
            tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.NORTH, flowerSprite, 4.001f, 0.0f, 0.0f, 16.0f, 16.0f);
            tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.NORTH, flowerSprite, 3.999f, 0.0f, 0.0f, 16.0f, 16.0f);
            tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.EAST, flowerSprite, 4.001f, 0.0f, 0.0f, 16.0f, 16.0f);
            tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.EAST, flowerSprite, 3.999f, 0.0f, 0.0f, 16.0f, 16.0f);
            tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.NORTH, flowerSprite, 12.001f, 0.0f, 0.0f, 16.0f, 16.0f);
            tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.NORTH, flowerSprite, 11.999f, 0.0f, 0.0f, 16.0f, 16.0f);
            tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.EAST, flowerSprite, 12.001f, 0.0f, 0.0f, 16.0f, 16.0f);
            tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.EAST, flowerSprite, 11.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        }
        tessellator.translate(0.0f, 0.75f, 0.0f);
        tessellator.popMatrix();
        ImmutableList quads = tessellator.getQuads();
        tessellator.draw();
        return quads;
    }

    private static void registerItemColors() {
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            if (stack.func_77973_b() instanceof IAgriSeedItem) {
                IAgriSeedItem seedItem = (IAgriSeedItem)stack.func_77973_b();
                String id = seedItem.getPlant(stack).getId();
                int color = MysticalAgricultureCompatClient.colorForFlower(id);
                return color == -1 ? -1 : -16777216 + color;
            }
            return -1;
        }, new IItemProvider[]{AgriItemRegistry.getInstance().seed});
    }

    public static int colorForFlower(String plantId) {
        ICrop mysticalCrop = MysticalAgricultureCompatClient.getCropFromPlantId(plantId);
        return mysticalCrop == null ? -1 : mysticalCrop.getFlowerColor();
    }

    public static int colorForSeed(String plantId) {
        ICrop crop = MysticalAgricultureCompatClient.getCropFromPlantId(plantId);
        return crop != null && crop.isSeedColored() ? crop.getSeedColor() : -1;
    }

    public static ICrop getCropFromPlantId(String plantId) {
        String path = plantId.split(":")[1];
        ResourceLocation location = new ResourceLocation(path.substring(0, path.length() - 6));
        return MysticalAgricultureAPI.getCropRegistry().getCropById(location);
    }
}

