/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.jei;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.capability.CapabilityResearchedPlants;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.AgriItemRegistry;
import com.infinityraider.agricraft.plugins.jei.AgriAnvilRecipes;
import com.infinityraider.agricraft.plugins.jei.AgriIngredientPlant;
import com.infinityraider.agricraft.plugins.jei.AgriRecipeCategoryClipping;
import com.infinityraider.agricraft.plugins.jei.AgriRecipeCategoryGrowthRequirements;
import com.infinityraider.agricraft.plugins.jei.AgriRecipeCategoryMutation;
import com.infinityraider.agricraft.plugins.jei.AgriRecipeCategoryProduce;
import com.infinityraider.agricraft.plugins.jei.IAgriDrawable;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation(AgriCraft.instance.getModId(), "compat_jei");
    private static IJeiRuntime jei;

    @Nullable
    public static IJeiRuntime getJei() {
        return jei;
    }

    public static void hideMutation(IAgriMutation mutation) {
        if (jei != null) {
            jei.getRecipeManager().hideRecipe((Object)mutation, AgriRecipeCategoryMutation.ID);
        }
    }

    public static void unHideMutation(IAgriMutation mutation) {
        if (jei != null) {
            jei.getRecipeManager().unhideRecipe((Object)mutation, AgriRecipeCategoryMutation.ID);
        }
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jei = jeiRuntime;
        if (((Config)AgriCraft.instance.getConfig()).progressiveJEI()) {
            PlayerEntity player = AgriCraft.instance.getClientPlayer();
            AgriApi.getMutationRegistry().stream().forEach(mutation -> {
                if (CapabilityResearchedPlants.getInstance().isMutationResearched(player, (IAgriMutation)mutation)) {
                    JeiPlugin.unHideMutation(mutation);
                } else {
                    JeiPlugin.hideMutation(mutation);
                }
            });
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        AgriRecipeCategoryMutation.registerRecipeCatalysts(registration);
        AgriRecipeCategoryProduce.registerRecipeCatalysts(registration);
        AgriRecipeCategoryClipping.registerRecipeCatalysts(registration);
        AgriRecipeCategoryGrowthRequirements.registerRecipeCatalysts(registration);
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        AgriIngredientPlant.register(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AgriRecipeCategoryMutation()});
        registration.addRecipeCategories(new IRecipeCategory[]{new AgriRecipeCategoryProduce()});
        registration.addRecipeCategories(new IRecipeCategory[]{new AgriRecipeCategoryClipping()});
        registration.addRecipeCategories(new IRecipeCategory[]{new AgriRecipeCategoryGrowthRequirements(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        AgriRecipeCategoryMutation.registerRecipes(registration);
        AgriRecipeCategoryProduce.registerRecipes(registration);
        AgriRecipeCategoryClipping.registerRecipes(registration);
        AgriRecipeCategoryGrowthRequirements.registerRecipes(registration);
        AgriAnvilRecipes.registerRecipes(registration);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)AgriItemRegistry.getInstance().seed, (stack, context) -> {
            Optional<IAgriGenome> genome = AgriApi.getGenomeAdapterizer().valueOf(stack);
            return genome.map(s -> s.getPlant().getId()).orElse("generic");
        });
    }

    public static IAgriDrawable createAgriDrawable(ResourceLocation location, int u, int v, int w, int h, int textureWidth, int textureHeight) {
        return JeiPlugin.createAgriDrawable(location, u, v, w, h, w, h, textureWidth, textureHeight);
    }

    public static IAgriDrawable createAgriDrawable(final ResourceLocation location, final int u, final int v, final int w, final int h, final int uMax, final int vMax, final int textureWidth, final int textureHeight) {
        return new IAgriDrawable(){

            public int getWidth() {
                return w;
            }

            public int getHeight() {
                return h;
            }

            public void draw(MatrixStack transform, int x, int y) {
                this.bindTexture(location);
                Screen.func_238466_a_((MatrixStack)transform, (int)x, (int)y, (int)this.getWidth(), (int)this.getHeight(), (float)u, (float)v, (int)uMax, (int)vMax, (int)textureWidth, (int)textureHeight);
            }
        };
    }
}

