/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.jei;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.capability.CapabilityResearchedPlants;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.AgriItemRegistry;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.plugins.jei.AgriIngredientPlant;
import com.infinityraider.agricraft.plugins.jei.IAgriDrawable;
import com.infinityraider.agricraft.plugins.jei.JeiPlugin;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class AgriRecipeCategoryMutation
implements IRecipeCategory<IAgriMutation> {
    public static final ResourceLocation ID = new ResourceLocation(AgriCraft.instance.getModId(), "jei/mutation");
    public final IAgriDrawable icon = JeiPlugin.createAgriDrawable(new ResourceLocation(AgriCraft.instance.getModId(), "textures/item/crop_sticks_wood.png"), 0, 0, 16, 16, 16, 16);
    public final IAgriDrawable background = JeiPlugin.createAgriDrawable(new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/jei/crop_mutation.png"), 0, 0, 128, 128, 128, 128);

    public static void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AgriApi.getMutationRegistry().all(), ID);
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_wood), new ResourceLocation[]{ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_iron), new ResourceLocation[]{ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_obsidian), new ResourceLocation[]{ID});
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public Class<IAgriMutation> getRecipeClass() {
        return IAgriMutation.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"agricraft.gui.mutation", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IAgriMutation mutation, IIngredients ingredients) {
        ingredients.setInputLists(AgriIngredientPlant.TYPE, mutation.getParents().stream().map(plant -> this.isPlantResearched((IAgriPlant)plant) ? plant : NoPlant.getInstance()).map(ImmutableList::of).collect(Collectors.toList()));
        ingredients.setInputLists(VanillaTypes.ITEM, mutation.getParents().stream().map(plant -> this.isPlantResearched((IAgriPlant)plant) ? plant : NoPlant.getInstance()).map(IAgriPlant::toItemStack).map(ImmutableList::of).collect(Collectors.toList()));
        ingredients.setOutputLists(AgriIngredientPlant.TYPE, (List)ImmutableList.of((Object)ImmutableList.of((Object)(this.isPlantResearched(mutation.getChild()) ? mutation.getChild() : NoPlant.getInstance()))));
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of((Object)ImmutableList.of((Object)(this.isPlantResearched(mutation.getChild()) ? mutation.getChild() : NoPlant.getInstance()).toItemStack())));
    }

    public boolean isPlantResearched(IAgriPlant plant) {
        if (((Config)AgriCraft.instance.getConfig()).progressiveJEI()) {
            return CapabilityResearchedPlants.getInstance().isPlantResearched(AgriCraft.instance.getClientPlayer(), plant);
        }
        return true;
    }

    public void setRecipe(IRecipeLayout layout, @Nonnull IAgriMutation mutation, @Nonnull IIngredients ingredients) {
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).setOverrideDisplayFocus(null);
        layout.getIngredientsGroup(VanillaTypes.ITEM).setOverrideDisplayFocus(null);
        layout.setShapeless();
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).init(0, true, 25, 40);
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).init(1, true, 87, 40);
        layout.getIngredientsGroup(VanillaTypes.ITEM).init(0, true, 15, 5);
        layout.getIngredientsGroup(VanillaTypes.ITEM).init(1, true, 95, 5);
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).init(2, false, 56, 40);
        layout.getIngredientsGroup(VanillaTypes.ITEM).init(2, false, 55, 1);
        layout.getItemStacks().set(ingredients);
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).set(ingredients);
    }
}

