/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.botanypots;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.render.models.AgriPlantModelBridge;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BotanyPotsPlantRenderer
implements IRenderUtilities {
    private static final BotanyPotsPlantRenderer INSTANCE = new BotanyPotsPlantRenderer();
    private final Map<IRenderTypeBuffer.Impl, ThreadLocal<ITessellator>> tessellators = Maps.newConcurrentMap();

    public static BotanyPotsPlantRenderer getInstance() {
        return INSTANCE;
    }

    private BotanyPotsPlantRenderer() {
    }

    protected ITessellator getTessellator(IRenderTypeBuffer.Impl buffer) {
        return (ITessellator)this.tessellators.computeIfAbsent(buffer, aBuffer -> ThreadLocal.withInitial(() -> this.getVertexBufferTessellator((IRenderTypeBuffer.Impl)aBuffer, this.getRenderType()))).get();
    }

    public void renderPlant(IAgriPlant plant, IAgriGrowthStage stage, IAgriWeed weed, IAgriGrowthStage weedStage, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, Direction ... preferredSides) {
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            ITessellator tessellator = this.getTessellator((IRenderTypeBuffer.Impl)buffer);
            tessellator.pushMatrix();
            tessellator.setBrightness(light);
            tessellator.setOverlay(overlay);
            tessellator.applyTransformation(matrix.func_227866_c_().func_227870_a_());
            tessellator.startDrawingQuads();
            tessellator.addQuads(this.fetchQuads(plant, stage, preferredSides));
            tessellator.addQuads(this.fetchQuads(weed, weedStage, preferredSides));
            tessellator.draw();
            tessellator.popMatrix();
        }
    }

    protected List<BakedQuad> fetchQuads(IAgriPlant plant, IAgriGrowthStage stage, Direction ... sides) {
        ArrayList quads = Lists.newArrayList();
        for (Direction dir : sides) {
            quads.addAll(AgriPlantModelBridge.getOrBakeQuads(plant, stage, dir));
        }
        quads.addAll(AgriPlantModelBridge.getOrBakeQuads(plant, stage, null));
        return quads;
    }

    protected List<BakedQuad> fetchQuads(IAgriWeed weed, IAgriGrowthStage stage, Direction ... sides) {
        ArrayList quads = Lists.newArrayList();
        for (Direction dir : sides) {
            quads.addAll(AgriPlantModelBridge.getOrBakeQuads(weed, stage, dir));
        }
        quads.addAll(AgriPlantModelBridge.getOrBakeQuads(weed, stage, null));
        return quads;
    }

    protected RenderType getRenderType() {
        return RenderType.func_228643_e_();
    }
}

