/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.network;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.util.LightHelper;
import com.infinityraider.infinitylib.network.MessageBase;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCompareLight
extends MessageBase {
    private RegistryKey<World> dimId;
    private BlockPos pos;
    private byte[] clientLightData;

    public MessageCompareLight() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public MessageCompareLight(World world, BlockPos pos) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)pos);
        this.dimId = world.func_234923_W_();
        this.pos = pos;
        this.clientLightData = LightHelper.getLightData(world, pos);
    }

    public NetworkDirection getMessageDirection() {
        return NetworkDirection.PLAY_TO_SERVER;
    }

    protected void processMessage(NetworkEvent.Context ctx) {
        World world = ((IProxy)AgriCraft.instance.proxy()).getWorldFromDimension(this.dimId);
        ServerPlayerEntity player = ctx.getSender();
        byte[] serverLightData = LightHelper.getLightData(world, this.pos);
        LightHelper.messageLightData((PlayerEntity)player, this.clientLightData, serverLightData);
    }
}

