/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.requirement;

import com.infinityraider.agricraft.api.v1.plugin.IAgriPlugin;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSeasonLogic;
import com.infinityraider.agricraft.content.world.BlockGreenHouseAir;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SeasonLogic
implements IAgriSeasonLogic {
    private static final SeasonLogic INSTANCE = new SeasonLogic();
    private IAgriPlugin owner = null;
    private BiFunction<World, BlockPos, AgriSeason> getter = (world, pos) -> AgriSeason.ANY;

    public static SeasonLogic getInstance() {
        return INSTANCE;
    }

    private SeasonLogic() {
    }

    @Override
    public boolean isActive() {
        return this.getOwner() != null;
    }

    @Override
    public AgriSeason getSeason(World world, BlockPos pos) {
        if (this.isGreenHouse(world, pos)) {
            return AgriSeason.ANY;
        }
        return this.getter.apply(world, pos);
    }

    protected boolean isGreenHouse(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockGreenHouseAir;
    }

    @Override
    @Nullable
    public IAgriPlugin getOwner() {
        return this.owner;
    }

    @Override
    public void claim(IAgriPlugin plugin, BiFunction<World, BlockPos, AgriSeason> getter) {
        this.owner = plugin;
        this.getter = getter;
    }
}

