/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.requirement;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowCondition;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.requirement.IDefaultGrowConditionFactory;
import com.infinityraider.agricraft.api.v1.requirement.RequirementType;
import com.infinityraider.agricraft.impl.v1.requirement.GrowConditionBase;
import com.infinityraider.agricraft.reference.AgriToolTips;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class FactoryAbstract
implements IDefaultGrowConditionFactory {
    protected FactoryAbstract() {
    }

    protected abstract <P extends IAgriSoil.SoilProperty> GrowConditionBase<P> soilProperty(BiFunction<Integer, P, IAgriGrowthResponse> var1, Function<IAgriSoil, P> var2, P var3, List<ITextComponent> var4);

    @Override
    public GrowConditionBase<IAgriSoil.Humidity> soilHumidity(BiFunction<Integer, IAgriSoil.Humidity, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.soilProperty(response, IAgriSoil::getHumidity, IAgriSoil.Humidity.INVALID, tooltips);
    }

    @Override
    public GrowConditionBase<IAgriSoil.Acidity> soilAcidity(BiFunction<Integer, IAgriSoil.Acidity, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.soilProperty(response, IAgriSoil::getAcidity, IAgriSoil.Acidity.INVALID, tooltips);
    }

    @Override
    public GrowConditionBase<IAgriSoil.Nutrients> soilNutrients(BiFunction<Integer, IAgriSoil.Nutrients, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.soilProperty(response, IAgriSoil::getNutrients, IAgriSoil.Nutrients.INVALID, tooltips);
    }

    @Override
    public IAgriGrowCondition light(BiPredicate<Integer, Integer> strengthLightPredicate) {
        BiFunction<Integer, Integer, IAgriGrowthResponse> response = (str, light) -> strengthLightPredicate.test((Integer)str, (Integer)light) ? Responses.FERTILE : Responses.INFERTILE;
        return this.light(response, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.LIGHT));
    }

    @Override
    public IAgriGrowCondition redstone(BiPredicate<Integer, Integer> strengthRedstonePredicate) {
        BiFunction<Integer, Integer, IAgriGrowthResponse> response = (str, redstone) -> strengthRedstonePredicate.test((Integer)str, (Integer)redstone) ? Responses.FERTILE : Responses.INFERTILE;
        return this.redstone(response, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.REDSTONE));
    }

    @Override
    public IAgriGrowCondition fluidState(BiFunction<Integer, FluidState, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.blockStatesNearby(RequirementType.LIQUID, (str, stream) -> (IAgriGrowthResponse)response.apply((Integer)str, stream.findAny().map(AbstractBlock.AbstractBlockState::func_204520_s).orElse(Fluids.field_204541_a.func_207188_f())), Offsets.NONE, Offsets.NONE, tooltips);
    }

    @Override
    public IAgriGrowCondition fluidClass(BiFunction<Integer, Class<? extends Fluid>, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.fluid((Integer str, Fluid fluid) -> (IAgriGrowthResponse)response.apply((Integer)str, (Class<? extends Fluid>)fluid.getClass()), tooltips);
    }

    @Override
    public IAgriGrowCondition fluid(IntPredicate strength, Fluid fluid) {
        BiFunction<Integer, Fluid, IAgriGrowthResponse> response = (str, aFluid) -> strength.test((int)str) || fluid.equals(aFluid) ? Responses.FERTILE : Responses.INFERTILE;
        return this.fluid(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.FLUID).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new TranslationTextComponent(fluid.func_207188_f().func_206883_i().func_177230_c().func_149739_a()))));
    }

    @Override
    public IAgriGrowCondition fluidState(IntPredicate strength, FluidState fluid) {
        BiFunction<Integer, FluidState, IAgriGrowthResponse> response = (str, aFluid) -> strength.test((int)str) || fluid.equals(aFluid) ? Responses.FERTILE : Responses.INFERTILE;
        return this.fluidState(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.FLUID).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new TranslationTextComponent(fluid.func_206883_i().func_177230_c().func_149739_a()))));
    }

    @Override
    public IAgriGrowCondition fluidClass(IntPredicate strength, Class<? extends Fluid> fluid, List<ITextComponent> tooltips) {
        BiFunction<Integer, Fluid, IAgriGrowthResponse> response = (str, aFluid) -> strength.test((int)str) || fluid.isInstance(aFluid) ? Responses.FERTILE : Responses.INFERTILE;
        return this.fluid(response, tooltips);
    }

    @Override
    public IAgriGrowCondition fluids(IntPredicate strength, Collection<Fluid> fluids) {
        BiFunction<Integer, Fluid, IAgriGrowthResponse> response = (str, fluid) -> strength.test((int)str) || fluids.contains(fluid) ? Responses.FERTILE : Responses.INFERTILE;
        return this.fluid(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.FLUID).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(AgriToolTips.collect(fluids.stream().map(fluid -> fluid.func_207188_f().func_206883_i().func_177230_c().func_149739_a()).map(TranslationTextComponent::new), ", "))));
    }

    @Override
    public IAgriGrowCondition fluidStates(IntPredicate strength, Collection<FluidState> fluids) {
        BiFunction<Integer, FluidState, IAgriGrowthResponse> response = (str, fluid) -> strength.test((int)str) || fluids.contains(fluid) ? Responses.FERTILE : Responses.INFERTILE;
        return this.fluidState(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.FLUID).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(AgriToolTips.collect(fluids.stream().map(fluid -> fluid.func_206883_i().func_177230_c().func_149739_a()).map(TranslationTextComponent::new), ", "))));
    }

    @Override
    public IAgriGrowCondition biomeCategory(BiFunction<Integer, Biome.Category, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.biome((str, biome) -> (IAgriGrowthResponse)response.apply((Integer)str, biome.func_201856_r()), tooltips);
    }

    @Override
    public IAgriGrowCondition biome(IntPredicate strength, Biome biome, ITextComponent biomeName) {
        BiFunction<Integer, Biome, IAgriGrowthResponse> response = (str, aBiome) -> strength.test((int)str) || biome.equals(aBiome) ? Responses.FERTILE : Responses.INFERTILE;
        return this.biome(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.BIOME).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(biomeName)));
    }

    @Override
    public IAgriGrowCondition biomeCategory(IntPredicate strength, Biome.Category category, ITextComponent categoryName) {
        BiFunction<Integer, Biome, IAgriGrowthResponse> response = (str, biome) -> strength.test((int)str) || biome.func_201856_r().equals((Object)category) ? Responses.FERTILE : Responses.INFERTILE;
        return this.biome(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.BIOME_CATEGORY).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(categoryName)));
    }

    @Override
    public IAgriGrowCondition biomes(IntPredicate strength, Collection<Biome> biomes, Function<Biome, ITextComponent> nameFunction) {
        BiFunction<Integer, Biome, IAgriGrowthResponse> response = (str, aBiome) -> strength.test((int)str) || biomes.contains(aBiome) ? Responses.FERTILE : Responses.INFERTILE;
        return this.biome(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.BIOME).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(AgriToolTips.collect(biomes.stream().map(nameFunction), ", "))));
    }

    @Override
    public IAgriGrowCondition biomeCategories(IntPredicate strength, Collection<Biome.Category> categories, Function<Biome.Category, ITextComponent> nameFunction) {
        BiFunction<Integer, Biome, IAgriGrowthResponse> response = (str, biome) -> strength.test((int)str) || categories.contains(biome.func_201856_r()) ? Responses.FERTILE : Responses.INFERTILE;
        return this.biome(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.BIOME).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(AgriToolTips.collect(categories.stream().map(nameFunction), ", "))));
    }

    @Override
    public IAgriGrowCondition climate(BiFunction<Integer, Biome.Climate, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.biome((str, biome) -> (IAgriGrowthResponse)response.apply((Integer)str, this.getClimate((Biome)biome)), tooltips);
    }

    @Override
    public IAgriGrowCondition climate(IntPredicate strength, Biome.Climate climate, List<ITextComponent> tooltips) {
        BiFunction<Integer, Biome.Climate, IAgriGrowthResponse> response = (str, aClimate) -> strength.test((int)str) || climate.equals(aClimate) ? Responses.FERTILE : Responses.INFERTILE;
        return this.climate(response, tooltips);
    }

    @Override
    public IAgriGrowCondition climates(IntPredicate strength, Collection<Biome.Climate> climates, List<ITextComponent> tooltips) {
        BiFunction<Integer, Biome.Climate, IAgriGrowthResponse> response = (str, aClimate) -> strength.test((int)str) || climates.contains(aClimate) ? Responses.FERTILE : Responses.INFERTILE;
        return this.climate(response, tooltips);
    }

    private Biome.Climate getClimate(Biome biome) {
        return (Biome.Climate)ObfuscationReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String)"field_242423_j");
    }

    @Override
    public IAgriGrowCondition dimension(IntPredicate strength, RegistryKey<World> dimension, ITextComponent dimensionName) {
        BiFunction<Integer, RegistryKey<World>, IAgriGrowthResponse> response = (str, aDimension) -> strength.test((int)str) || aDimension.equals(dimension) ? Responses.FERTILE : Responses.INFERTILE;
        return this.dimensionFromKey(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.DIMENSION).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(dimensionName)));
    }

    @Override
    public IAgriGrowCondition dimension(IntPredicate strength, DimensionType dimension, ITextComponent dimensionName) {
        BiFunction<Integer, DimensionType, IAgriGrowthResponse> response = (str, aDimension) -> strength.test((int)str) || aDimension.equals(dimension) ? Responses.FERTILE : Responses.INFERTILE;
        return this.dimensionFromType(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.DIMENSION).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(dimensionName)));
    }

    @Override
    public IAgriGrowCondition withWeed(IntPredicate strength) {
        BiFunction<Integer, IAgriWeed, IAgriGrowthResponse> response = (str, aWeed) -> strength.test((int)str) || aWeed.isWeed() ? Responses.FERTILE : Responses.INFERTILE;
        return this.weed(response, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.WITH_WEED));
    }

    @Override
    public IAgriGrowCondition withWeed(IntPredicate strength, IAgriWeed weed) {
        BiFunction<Integer, IAgriWeed, IAgriGrowthResponse> response = (str, aWeed) -> strength.test((int)str) || aWeed.equals(weed) ? Responses.FERTILE : Responses.INFERTILE;
        return this.weed(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.WITH_WEED).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(weed.getWeedName())));
    }

    @Override
    public IAgriGrowCondition withoutWeed(IntPredicate strength) {
        BiFunction<Integer, IAgriWeed, IAgriGrowthResponse> response = (str, aWeed) -> strength.test((int)str) || !aWeed.isWeed() ? Responses.FERTILE : Responses.INFERTILE;
        return this.weed(response, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.WITHOUT_WEED));
    }

    @Override
    public IAgriGrowCondition withoutWeed(IntPredicate strength, IAgriWeed weed) {
        BiFunction<Integer, IAgriWeed, IAgriGrowthResponse> response = (str, aWeed) -> strength.test((int)str) || !aWeed.equals(weed) ? Responses.FERTILE : Responses.INFERTILE;
        return this.weed(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.WITHOUT_WEED).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(weed.getWeedName())));
    }

    @Override
    public IAgriGrowCondition day(IntPredicate strength) {
        BiFunction<Integer, Long, IAgriGrowthResponse> response = (str, time) -> strength.test((int)str) || time >= 0L && time <= 12000L ? Responses.FERTILE : Responses.INFERTILE;
        return this.time(response, Descriptions.DAY);
    }

    @Override
    public IAgriGrowCondition dusk(IntPredicate strength) {
        BiFunction<Integer, Long, IAgriGrowthResponse> response = (str, time) -> strength.test((int)str) || time >= 12000L && time <= 13000L ? Responses.FERTILE : Responses.INFERTILE;
        return this.time(response, Descriptions.DUSK);
    }

    @Override
    public IAgriGrowCondition night(IntPredicate strength) {
        BiFunction<Integer, Long, IAgriGrowthResponse> response = (str, time) -> strength.test((int)str) || time >= 13000L && time <= 23000L ? Responses.FERTILE : Responses.INFERTILE;
        return this.time(response, Descriptions.NIGHT);
    }

    @Override
    public IAgriGrowCondition dawn(IntPredicate strength) {
        BiFunction<Integer, Long, IAgriGrowthResponse> response = (str, time) -> strength.test((int)str) || time >= 23000L && time <= 24000L ? Responses.FERTILE : Responses.INFERTILE;
        return this.time(response, Descriptions.DAWN);
    }

    @Override
    public IAgriGrowCondition blockBelow(BiFunction<Integer, Block, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.stateBelow((str, state) -> (IAgriGrowthResponse)response.apply((Integer)str, state.func_177230_c()), tooltips);
    }

    @Override
    public IAgriGrowCondition stateBelow(BiFunction<Integer, BlockState, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.blockStatesNearby(RequirementType.BLOCK_BELOW, (strength, stream) -> (IAgriGrowthResponse)response.apply((Integer)strength, (BlockState)stream.findAny().get()), Offsets.BELOW, Offsets.BELOW, tooltips);
    }

    @Override
    public IAgriGrowCondition classBelow(BiFunction<Integer, Class<? extends Block>, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return this.blockBelow((str, block) -> (IAgriGrowthResponse)response.apply((Integer)str, (Class<? extends Block>)block.getClass()), tooltips);
    }

    @Override
    public IAgriGrowCondition blocksNearby(BiFunction<Integer, Stream<Block>, IAgriGrowthResponse> response, BlockPos minOffset, BlockPos maxOffset, List<ITextComponent> tooltips) {
        return this.blockStatesNearby((Integer str, Stream<BlockState> stream) -> (IAgriGrowthResponse)response.apply((Integer)str, stream.map(AbstractBlock.AbstractBlockState::func_177230_c)), minOffset, maxOffset, tooltips);
    }

    @Override
    public IAgriGrowCondition blockStatesNearby(BiFunction<Integer, Stream<BlockState>, IAgriGrowthResponse> response, BlockPos minOffset, BlockPos maxOffset, List<ITextComponent> tooltips) {
        return this.blockStatesNearby(RequirementType.BLOCKS_NEARBY, response, minOffset, maxOffset, tooltips);
    }

    @Override
    public IAgriGrowCondition classNearby(BiFunction<Integer, Stream<Class<? extends Block>>, IAgriGrowthResponse> response, BlockPos minOffset, BlockPos maxOffset, List<ITextComponent> tooltips) {
        return this.blocksNearby((Integer str, Stream<Block> stream) -> (IAgriGrowthResponse)response.apply((Integer)str, (Stream<Class<? extends Block>>)stream.map(Object::getClass)), minOffset, maxOffset, tooltips);
    }

    @Override
    public IAgriGrowCondition blockNearby(Block block, int amount, BlockPos minOffset, BlockPos maxOffset) {
        BiFunction<Integer, Stream<BlockState>, IAgriGrowthResponse> response = (str, stream) -> stream.map(AbstractBlock.AbstractBlockState::func_177230_c).filter(block::equals).count() >= (long)amount ? Responses.FERTILE : Responses.INFERTILE;
        return this.blockStatesNearby(response, minOffset, maxOffset, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.equalTo(Descriptions.BLOCK_NEARBY, amount), (Object)new TranslationTextComponent(block.func_149739_a())));
    }

    @Override
    public IAgriGrowCondition blockStateNearby(BlockState state, int amount, BlockPos minOffset, BlockPos maxOffset) {
        BiFunction<Integer, Stream<BlockState>, IAgriGrowthResponse> response = (str, stream) -> stream.filter(state::equals).count() >= (long)amount ? Responses.FERTILE : Responses.INFERTILE;
        return this.blockStatesNearby(response, minOffset, maxOffset, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.equalTo(Descriptions.BLOCK_NEARBY, amount), (Object)new TranslationTextComponent(state.func_177230_c().func_149739_a())));
    }

    @Override
    public IAgriGrowCondition blocksNearby(Collection<Block> blocks, int amount, BlockPos minOffset, BlockPos maxOffset) {
        BiFunction<Integer, Stream<BlockState>, IAgriGrowthResponse> response = (str, stream) -> stream.map(AbstractBlock.AbstractBlockState::func_177230_c).filter(blocks::contains).count() >= (long)amount ? Responses.FERTILE : Responses.INFERTILE;
        return this.blockStatesNearby(response, minOffset, maxOffset, Stream.concat(Stream.of(Descriptions.equalTo(Descriptions.BLOCK_NEARBY, amount)), blocks.stream().map(Block::func_149739_a).map(TranslationTextComponent::new)).collect(Collectors.toList()));
    }

    @Override
    public IAgriGrowCondition blockStatesNearby(Collection<BlockState> states, int amount, BlockPos minOffset, BlockPos maxOffset) {
        BiFunction<Integer, Stream<BlockState>, IAgriGrowthResponse> response = (str, stream) -> stream.filter(states::contains).count() >= (long)amount ? Responses.FERTILE : Responses.INFERTILE;
        return this.blockStatesNearby(response, minOffset, maxOffset, Stream.concat(Stream.of(Descriptions.equalTo(Descriptions.BLOCK_NEARBY, amount)), states.stream().map(AbstractBlock.AbstractBlockState::func_177230_c).map(Block::func_149739_a).map(TranslationTextComponent::new)).collect(Collectors.toList()));
    }

    protected abstract GrowConditionBase<Stream<BlockState>> blockStatesNearby(RequirementType var1, BiFunction<Integer, Stream<BlockState>, IAgriGrowthResponse> var2, BlockPos var3, BlockPos var4, List<ITextComponent> var5);

    @Override
    public IAgriGrowCondition entityNearby(IntUnaryOperator strengthToAmount, EntityType<?> entityType, double range) {
        BiFunction<Integer, Stream<Entity>, IAgriGrowthResponse> response = (str, stream) -> {
            block3: {
                block2: {
                    int amount = strengthToAmount.applyAsInt((int)str);
                    if (amount <= 0) break block2;
                    if ((long)amount > stream.map(Entity::func_200600_R).filter(entityType::equals).count()) break block3;
                }
                return Responses.FERTILE;
            }
            return Responses.INFERTILE;
        };
        return this.entitiesNearby(response, range, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.ENTITY_NEARBY).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(entityType.func_212546_e())));
    }

    @Override
    public IAgriGrowCondition entityNearby(IntUnaryOperator strengthToAmount, Class<? extends Entity> entityClass, double range, ITextComponent entityName) {
        BiFunction<Integer, Stream<Entity>, IAgriGrowthResponse> response = (str, stream) -> {
            block3: {
                block2: {
                    int amount = strengthToAmount.applyAsInt((int)str);
                    if (amount <= 0) break block2;
                    if ((long)amount > stream.filter(entityClass::isInstance).count()) break block3;
                }
                return Responses.FERTILE;
            }
            return Responses.INFERTILE;
        };
        return this.entitiesNearby(response, range, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.ENTITY_NEARBY).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(entityName)));
    }

    @Override
    public IAgriGrowCondition noRain(IntPredicate strength) {
        BiFunction<Integer, Boolean, IAgriGrowthResponse> response = (str, rain) -> strength.test((int)str) || rain == false ? Responses.FERTILE : Responses.INFERTILE;
        return this.rain(response, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.NO_RAIN));
    }

    @Override
    public IAgriGrowCondition inRain(IntPredicate strength) {
        BiFunction<Integer, Boolean, IAgriGrowthResponse> response = (str, rain) -> strength.test((int)str) || rain != false ? Responses.FERTILE : Responses.INFERTILE;
        return this.rain(response, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.RAIN));
    }

    @Override
    public IAgriGrowCondition noSnow(IntPredicate strength) {
        BiFunction<Integer, Boolean, IAgriGrowthResponse> response = (str, snow) -> strength.test((int)str) || snow == false ? Responses.FERTILE : Responses.INFERTILE;
        return this.snow(response, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.NO_SNOW));
    }

    @Override
    public IAgriGrowCondition inSnow(IntPredicate strength) {
        BiFunction<Integer, Boolean, IAgriGrowthResponse> response = (str, snow) -> strength.test((int)str) || snow != false ? Responses.FERTILE : Responses.INFERTILE;
        return this.snow(response, (List<ITextComponent>)ImmutableList.of((Object)Descriptions.SNOW));
    }

    @Override
    public IAgriGrowCondition season(IntPredicate strength, AgriSeason season) {
        BiFunction<Integer, AgriSeason, IAgriGrowthResponse> response = (str, aSeason) -> strength.test((int)str) || season.matches((AgriSeason)((Object)aSeason)) ? Responses.FERTILE : Responses.INFERTILE;
        return this.season(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.SEASON).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)season.getDisplayName())));
    }

    @Override
    public IAgriGrowCondition seasons(IntPredicate strength, Collection<AgriSeason> seasons) {
        BiFunction<Integer, AgriSeason, IAgriGrowthResponse> response = (str, aSeason) -> {
            IAgriGrowthResponse iAgriGrowthResponse;
            if (!strength.test((int)str)) {
                if (!seasons.stream().anyMatch(aSeason::matches)) {
                    iAgriGrowthResponse = Responses.INFERTILE;
                    return iAgriGrowthResponse;
                }
            }
            iAgriGrowthResponse = Responses.FERTILE;
            return iAgriGrowthResponse;
        };
        return this.season(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.SEASON).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(AgriToolTips.collect(seasons.stream().map(AgriSeason::getDisplayName), ", "))));
    }

    @Override
    public IAgriGrowCondition inVillage(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236381_q_, StructureNames.VILLAGE);
    }

    @Override
    public IAgriGrowCondition inPillagerOutpost(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236366_b_, StructureNames.PILLAGER_OUTPOST);
    }

    @Override
    public IAgriGrowCondition inMineshaft(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236367_c_, StructureNames.MINESHAFT);
    }

    @Override
    public IAgriGrowCondition inMansion(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236368_d_, StructureNames.WOODLAND_MANSION);
    }

    @Override
    public IAgriGrowCondition inPyramid(IntPredicate strength) {
        BiFunction<Integer, Stream<Structure<?>>, IAgriGrowthResponse> response = (str, stream) -> {
            if (strength.test((int)str)) {
                return Responses.FERTILE;
            }
            if (stream.anyMatch(structure -> structure.equals(Structure.field_236370_f_) || structure.equals(Structure.field_236369_e_))) {
                return Responses.FERTILE;
            }
            return Responses.INFERTILE;
        };
        return this.structure(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.OUT_STRUCTURE).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(StructureNames.PYRAMID)));
    }

    @Override
    public IAgriGrowCondition inJunglePyramid(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236369_e_, StructureNames.JUNGLE_PYRAMID);
    }

    @Override
    public IAgriGrowCondition inDesertPyramid(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236370_f_, StructureNames.DESERT_PYRAMID);
    }

    @Override
    public IAgriGrowCondition inIgloo(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236371_g_, StructureNames.IGLOO);
    }

    @Override
    public IAgriGrowCondition inRuinedPortal(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236372_h_, StructureNames.RUINED_PORTAL);
    }

    @Override
    public IAgriGrowCondition inShipwreck(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236373_i_, StructureNames.SHIPWRECK);
    }

    @Override
    public IAgriGrowCondition inSwampHut(IntPredicate strength) {
        return this.inStructure(strength, (Structure<?>)Structure.field_236374_j_, StructureNames.SWAMP_HUT);
    }

    @Override
    public IAgriGrowCondition inStronghold(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236375_k_, StructureNames.STRONGHOLD);
    }

    @Override
    public IAgriGrowCondition inMonument(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236376_l_, StructureNames.MONUMENT);
    }

    @Override
    public IAgriGrowCondition inOceanRuin(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236377_m_, StructureNames.OCEAN_RUIN);
    }

    @Override
    public IAgriGrowCondition inFortress(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236378_n_, StructureNames.FORTRESS);
    }

    @Override
    public IAgriGrowCondition inEndCity(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236379_o_, StructureNames.END_CITY);
    }

    @Override
    public IAgriGrowCondition inBuriedTreasure(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236380_p_, StructureNames.BURIED_TREASURE);
    }

    @Override
    public IAgriGrowCondition inNetherFossil(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236382_r_, StructureNames.NETHER_FOSSIL);
    }

    @Override
    public IAgriGrowCondition inBastionRemnant(IntPredicate strength) {
        return this.inStructure(strength, Structure.field_236383_s_, StructureNames.BASTION_REMNANT);
    }

    @Override
    public IAgriGrowCondition notInVillage(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236381_q_, StructureNames.VILLAGE);
    }

    @Override
    public IAgriGrowCondition notInPillagerOutpost(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236366_b_, StructureNames.PILLAGER_OUTPOST);
    }

    @Override
    public IAgriGrowCondition notInMineshaft(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236367_c_, StructureNames.MINESHAFT);
    }

    @Override
    public IAgriGrowCondition notInMansion(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236368_d_, StructureNames.WOODLAND_MANSION);
    }

    @Override
    public IAgriGrowCondition notInPyramid(IntPredicate strength) {
        BiFunction<Integer, Stream<Structure<?>>, IAgriGrowthResponse> response = (str, stream) -> {
            if (strength.test((int)str)) {
                return Responses.FERTILE;
            }
            if (stream.anyMatch(structure -> structure.equals(Structure.field_236370_f_) || structure.equals(Structure.field_236369_e_))) {
                return Responses.INFERTILE;
            }
            return Responses.FERTILE;
        };
        return this.structure(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.OUT_STRUCTURE).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(StructureNames.PYRAMID)));
    }

    @Override
    public IAgriGrowCondition notInJunglePyramid(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236369_e_, StructureNames.JUNGLE_PYRAMID);
    }

    @Override
    public IAgriGrowCondition notInDesertPyramid(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236370_f_, StructureNames.DESERT_PYRAMID);
    }

    @Override
    public IAgriGrowCondition notInIgloo(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236371_g_, StructureNames.IGLOO);
    }

    @Override
    public IAgriGrowCondition notInRuinedPortal(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236372_h_, StructureNames.RUINED_PORTAL);
    }

    @Override
    public IAgriGrowCondition notInShipwreck(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236373_i_, StructureNames.SHIPWRECK);
    }

    @Override
    public IAgriGrowCondition notInSwampHut(IntPredicate strength) {
        return this.notInStructure(strength, (Structure<?>)Structure.field_236374_j_, StructureNames.SWAMP_HUT);
    }

    @Override
    public IAgriGrowCondition notInStronghold(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236375_k_, StructureNames.STRONGHOLD);
    }

    @Override
    public IAgriGrowCondition notInMonument(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236376_l_, StructureNames.MONUMENT);
    }

    @Override
    public IAgriGrowCondition notInOceanRuin(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236377_m_, StructureNames.OCEAN_RUIN);
    }

    @Override
    public IAgriGrowCondition notInFortress(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236378_n_, StructureNames.FORTRESS);
    }

    @Override
    public IAgriGrowCondition notInEndCity(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236379_o_, StructureNames.END_CITY);
    }

    @Override
    public IAgriGrowCondition notInBuriedTreasure(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236380_p_, StructureNames.BURIED_TREASURE);
    }

    @Override
    public IAgriGrowCondition notInNetherFossil(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236382_r_, StructureNames.NETHER_FOSSIL);
    }

    @Override
    public IAgriGrowCondition notInBastionRemnant(IntPredicate strength) {
        return this.notInStructure(strength, Structure.field_236383_s_, StructureNames.BASTION_REMNANT);
    }

    @Override
    public IAgriGrowCondition inStructure(IntPredicate predicate, Structure<?> structure, ITextComponent structureName) {
        BiFunction<Integer, Stream<Structure<?>>, IAgriGrowthResponse> response = (str, stream) -> {
            IAgriGrowthResponse iAgriGrowthResponse;
            if (!predicate.test((int)str)) {
                if (!stream.anyMatch(structure::equals)) {
                    iAgriGrowthResponse = Responses.INFERTILE;
                    return iAgriGrowthResponse;
                }
            }
            iAgriGrowthResponse = Responses.FERTILE;
            return iAgriGrowthResponse;
        };
        return this.structure(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.IN_STRUCTURE).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(structureName)));
    }

    @Override
    public IAgriGrowCondition notInStructure(IntPredicate predicate, Structure<?> structure, ITextComponent structureName) {
        BiFunction<Integer, Stream<Structure<?>>, IAgriGrowthResponse> response = (str, stream) -> {
            IAgriGrowthResponse iAgriGrowthResponse;
            if (!predicate.test((int)str)) {
                if (!stream.noneMatch(structure::equals)) {
                    iAgriGrowthResponse = Responses.INFERTILE;
                    return iAgriGrowthResponse;
                }
            }
            iAgriGrowthResponse = Responses.FERTILE;
            return iAgriGrowthResponse;
        };
        return this.structure(response, (List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(Descriptions.IN_STRUCTURE).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(structureName)));
    }

    private static final class StructureNames {
        private static final ITextComponent VILLAGE = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.village");
        private static final ITextComponent PILLAGER_OUTPOST = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.pillager_outpost");
        private static final ITextComponent MINESHAFT = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.mineshaft");
        private static final ITextComponent WOODLAND_MANSION = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.woodland_mansion");
        private static final ITextComponent PYRAMID = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.pyramid");
        private static final ITextComponent JUNGLE_PYRAMID = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.jungle_pyramid");
        private static final ITextComponent DESERT_PYRAMID = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.desert_pyramid");
        private static final ITextComponent IGLOO = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.igloo");
        private static final ITextComponent RUINED_PORTAL = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.ruined_portal");
        private static final ITextComponent SHIPWRECK = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.shipwreck");
        private static final ITextComponent SWAMP_HUT = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.swamp_hut");
        private static final ITextComponent STRONGHOLD = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.stronghold");
        private static final ITextComponent MONUMENT = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.monument");
        private static final ITextComponent OCEAN_RUIN = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.ocean_ruin");
        private static final ITextComponent FORTRESS = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.fortress");
        private static final ITextComponent END_CITY = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.end_city");
        private static final ITextComponent BURIED_TREASURE = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.buried_treasure");
        private static final ITextComponent NETHER_FOSSIL = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.nether_fossil");
        private static final ITextComponent BASTION_REMNANT = new TranslationTextComponent(AgriCraft.instance.getModId() + ".structure.bastion_remnant");

        private StructureNames() {
        }
    }

    public static final class Descriptions {
        public static final ITextComponent SOIL = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.soil");
        public static final ITextComponent SOIL_HUMIDITY = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.soil.humidity");
        public static final ITextComponent SOIL_ACIDITY = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.soil.acidity");
        public static final ITextComponent SOIL_NUTRIENTS = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.soil.nutrients");
        public static final ITextComponent LIGHT = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.light");
        public static final ITextComponent REDSTONE = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.redstone");
        public static final ITextComponent FLUID = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.fluid");
        public static final ITextComponent BIOME = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.biome");
        public static final ITextComponent BIOME_CATEGORY = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.biome_category");
        public static final ITextComponent DIMENSION = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.dimension");
        public static final ITextComponent WITH_WEED = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.with_weed");
        public static final ITextComponent WITHOUT_WEED = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.without_weed");
        public static final List<ITextComponent> DAY = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.day"));
        public static final List<ITextComponent> DUSK = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.dusk"));
        public static final List<ITextComponent> NIGHT = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.night"));
        public static final List<ITextComponent> DAWN = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.dawn"));
        public static final ITextComponent BLOCK_BELOW = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.block_below");
        public static final ITextComponent BLOCK_NEARBY = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.block_nearby");
        public static final ITextComponent ENTITY_NEARBY = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.entity_nearby");
        private static final ITextComponent NO_RAIN = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.no_rain");
        private static final ITextComponent RAIN = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.rain");
        private static final ITextComponent NO_SNOW = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.no_snow");
        private static final ITextComponent SNOW = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.snow");
        public static final ITextComponent SEASON = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.season");
        public static final ITextComponent IN_STRUCTURE = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.structure_in");
        public static final ITextComponent OUT_STRUCTURE = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.structure_out");

        public static ITextComponent inRange(ITextComponent base, int min, int max) {
            return new StringTextComponent("").func_230529_a_(base).func_230529_a_((ITextComponent)new StringTextComponent("[" + min + "; " + max + "]"));
        }

        public static ITextComponent equalTo(ITextComponent base, int value) {
            return new StringTextComponent("").func_230529_a_(base).func_230529_a_((ITextComponent)new StringTextComponent("" + value));
        }

        public static ITextComponent weed(IAgriWeed weed, IAgriGrowthStage stage) {
            return new StringTextComponent("").func_230529_a_(weed.getWeedName()).func_230529_a_((ITextComponent)new StringTextComponent(" (")).func_230529_a_(AgriToolTips.getGrowthTooltip(stage)).func_230529_a_((ITextComponent)new StringTextComponent(")"));
        }

        private Descriptions() {
        }
    }

    public static final class Responses {
        public static final IAgriGrowthResponse FERTILE = IAgriGrowthResponse.FERTILE;
        public static final IAgriGrowthResponse INFERTILE = IAgriGrowthResponse.INFERTILE;
    }

    private static final class Offsets {
        private static final BlockPos NONE = new BlockPos(0, 0, 0);
        private static final BlockPos SOIL = new BlockPos(0, -1, 0);
        private static final BlockPos BELOW = new BlockPos(0, -2, 0);

        private Offsets() {
        }
    }
}

