/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.requirement;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.api.v1.event.AgriRegistryEvent;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoilProvider;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoilRegistry;
import com.infinityraider.agricraft.impl.v1.AgriRegistryAbstract;
import com.infinityraider.agricraft.impl.v1.requirement.NoSoil;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;

public class AgriSoilRegistry
extends AgriRegistryAbstract<IAgriSoil>
implements IAgriSoilRegistry {
    public static final IAgriSoil NO_SOIL = NoSoil.getInstance();
    private static final AgriSoilRegistry INSTANCE = new AgriSoilRegistry();
    private static final IAgriSoilProvider EMPTY = (world, pos, state) -> Optional.empty();
    private final Map<Block, IAgriSoilProvider> providers = Maps.newHashMap();

    public static AgriSoilRegistry getInstance() {
        return INSTANCE;
    }

    private AgriSoilRegistry() {
        this.directAdd(NO_SOIL);
    }

    @Override
    public boolean remove(@Nullable IAgriSoil element) {
        return NO_SOIL != element && super.remove(element);
    }

    @Override
    @Nonnull
    public Stream<IAgriSoil> stream() {
        return super.stream().filter(IAgriSoil::isSoil);
    }

    @Override
    @Nullable
    protected AgriRegistryEvent<IAgriSoil> createEvent(IAgriSoil element) {
        return new AgriRegistryEvent.Soil(this, element);
    }

    @Override
    public void registerSoilProvider(@Nonnull Block block, @Nonnull IAgriSoilProvider soilProvider) {
        this.providers.put(block, soilProvider);
    }

    @Override
    @Nonnull
    public IAgriSoilProvider getProvider(@Nonnull Block block) {
        return this.providers.getOrDefault(block, EMPTY);
    }

    @Override
    public IAgriSoil getNoSoil() {
        return NO_SOIL;
    }
}

