/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.genetics;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationEngine;
import com.infinityraider.agricraft.api.v1.genetics.IAllele;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.genetics.GeneSpecies;
import com.infinityraider.agricraft.impl.v1.stats.AgriStatRegistry;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.util.Tuple;

public class AgriMutationEngine
implements IAgriMutationEngine {
    private IAgriMutationEngine.IParentSelector selector = this::selectAndSortCandidates;
    private IAgriMutationEngine.ICloneLogic cloner = (parent, random) -> AgriApi.getAgriGenomeBuilder(parent.getTrait(GeneSpecies.getInstance())).populate(gene -> this.cloneGene((IAgriGene)gene, parent, random)).build();
    private IAgriMutationEngine.ICombineLogic combiner = (parents, random) -> AgriApi.getAgriGenomeBuilder(((IAgriGenome)parents.func_76341_a()).getTrait(GeneSpecies.getInstance())).populate(gene -> this.mutateGene((IAgriGene)gene, (Tuple<IAgriGenome, IAgriGenome>)parents, random)).build();

    protected IAgriMutationEngine.IParentSelector getSelector() {
        return this.selector;
    }

    protected IAgriMutationEngine.ICloneLogic getCloner() {
        return this.cloner;
    }

    protected IAgriMutationEngine.ICombineLogic getCombiner() {
        return this.combiner;
    }

    @Override
    public boolean handleMutationTick(IAgriCrop crop, Stream<IAgriCrop> neighbours, Random random) {
        List<IAgriCrop> candidates = this.getSelector().selectAndOrder(neighbours, random);
        if (candidates.size() <= 0) {
            return false;
        }
        if (candidates.size() == 1) {
            return this.doClone(crop, candidates.get(0), random);
        }
        return this.doCombine(crop, candidates.get(0), candidates.get(1), random);
    }

    @Nonnull
    protected List<IAgriCrop> selectAndSortCandidates(Stream<IAgriCrop> neighbours, Random random) {
        return neighbours.filter(IAgriCrop::isValid).filter(IAgriCrop::isMature).filter(crop -> !((Config)AgriCraft.instance.getConfig()).onlyFertileCropsCanSpread() || crop.isFertile()).sorted(Comparator.comparingInt(this::sorter)).filter(neighbour -> this.rollFertility((IAgriCrop)neighbour, random)).collect(Collectors.toList());
    }

    protected boolean doClone(IAgriCrop target, IAgriCrop parent, Random random) {
        IAgriPlant plant = parent.getPlant();
        if (plant.allowsCloning(parent.getGrowthStage()) && random.nextDouble() < parent.getPlant().getSpreadChance(parent.getGrowthStage())) {
            return parent.getGenome().map(genome -> this.spawnChild(target, this.getCloner().clone((IAgriGenome)genome, random))).orElse(false);
        }
        return false;
    }

    protected boolean doCombine(IAgriCrop target, IAgriCrop a, IAgriCrop b, Random random) {
        return a.getGenome().flatMap(genA -> b.getGenome().map(genB -> {
            IAgriGenome genome = this.getCombiner().combine((Tuple<IAgriGenome, IAgriGenome>)new Tuple(genA, genB), random);
            return this.spawnChild(target, genome);
        })).orElse(false);
    }

    protected int sorter(IAgriCrop crop) {
        IAgriStat fertility = AgriStatRegistry.getInstance().fertilityStat();
        return fertility.getMax() - crop.getStats().getFertility();
    }

    protected boolean rollFertility(IAgriCrop crop, Random random) {
        IAgriStat fertility = AgriStatRegistry.getInstance().fertilityStat();
        return random.nextInt(fertility.getMax()) < crop.getStats().getFertility();
    }

    protected boolean spawnChild(IAgriCrop target, IAgriGenome genome) {
        target.setCrossCrop(false);
        return target.spawnGenome(genome);
    }

    protected <T> IAgriGenePair<T> mutateGene(IAgriGene<T> gene, Tuple<IAgriGenome, IAgriGenome> parents, Random rand) {
        return gene.mutator().pickOrMutate(gene, this.pickRandomAllele(((IAgriGenome)parents.func_76341_a()).getGenePair(gene), rand), this.pickRandomAllele(((IAgriGenome)parents.func_76340_b()).getGenePair(gene), rand), parents, rand);
    }

    protected <T> IAgriGenePair<T> cloneGene(IAgriGene<T> gene, IAgriGenome parent, Random rand) {
        if (((Config)AgriCraft.instance.getConfig()).allowCloneMutations()) {
            return gene.mutator().pickOrMutate(gene, parent.getGenePair(gene).getDominant(), parent.getGenePair(gene).getRecessive(), (Tuple<IAgriGenome, IAgriGenome>)new Tuple((Object)parent, (Object)parent), rand);
        }
        return parent.getGenePair(gene).clone();
    }

    protected <T> IAllele<T> pickRandomAllele(IAgriGenePair<T> pair, Random random) {
        return random.nextBoolean() ? pair.getDominant() : pair.getRecessive();
    }

    @Override
    public IAgriMutationEngine setSelectionLogic(@Nonnull IAgriMutationEngine.IParentSelector selector) {
        this.selector = Objects.requireNonNull(selector);
        return this;
    }

    @Override
    public IAgriMutationEngine setCloneLogic(@Nonnull IAgriMutationEngine.ICloneLogic cloneLogic) {
        this.cloner = Objects.requireNonNull(cloneLogic);
        return this;
    }

    @Override
    public IAgriMutationEngine setCombineLogic(@Nonnull IAgriMutationEngine.ICombineLogic combineLogic) {
        this.combiner = Objects.requireNonNull(combineLogic);
        return this;
    }
}

