/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.agricraft.agricore.util.AgriValidator;
import com.agricraft.agricore.util.TypeHelper;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.impl.v1.plant.JsonPlantCallback;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.util.TagUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class AgriValidatorImpl
implements AgriValidator {
    @Override
    public <T> boolean isValidObject(Class<T> token, String object, boolean useTag) {
        if (TypeHelper.isType(ItemStack.class, token)) {
            return this.isValidItem(object, useTag);
        }
        if (TypeHelper.isType(BlockState.class, token)) {
            return this.isValidBlock(object, useTag);
        }
        if (TypeHelper.isType(FluidState.class, token)) {
            return this.isValidFluid(object, useTag);
        }
        return false;
    }

    @Override
    @Nonnull
    public <T> Class<T> getTokenClass(String token) {
        if ("item".equalsIgnoreCase(token)) {
            return ItemStack.class;
        }
        if ("block".equalsIgnoreCase(token)) {
            return BlockState.class;
        }
        if ("fluid".equalsIgnoreCase(token)) {
            return FluidState.class;
        }
        AgriCraft.instance.getLogger().error("Invalid token class: " + token + ", encountered, check your jsons", new Object[0]);
        return Object.class;
    }

    @Override
    public boolean isValidRenderType(String renderType) {
        return ((IProxy)AgriCraft.instance.proxy()).isValidRenderType(renderType);
    }

    @Override
    public boolean isValidSeason(String season) {
        return AgriSeason.fromString(season).isPresent();
    }

    protected boolean isValidItem(String item, boolean useTag) {
        String[] parts = item.split(":");
        if (parts.length != 2) {
            return false;
        }
        if (useTag && TagUtil.isValidTag(ItemTags.func_199903_a(), item)) {
            return true;
        }
        try {
            return ForgeRegistries.ITEMS.containsKey(new ResourceLocation(parts[0], parts[1]));
        }
        catch (Exception e) {
            AgriCraft.instance.getLogger().error("Failed to parse item: " + item + ", encountered Exception", new Object[0]);
            AgriCraft.instance.getLogger().printStackTrace(e);
            return false;
        }
    }

    protected boolean isValidBlock(String block, boolean useTag) {
        String[] parts = block.split(":");
        if (parts.length != 2) {
            return false;
        }
        if (useTag && TagUtil.isValidTag(BlockTags.func_199896_a(), block)) {
            return true;
        }
        try {
            return ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(parts[0], parts[1]));
        }
        catch (Exception e) {
            AgriCraft.instance.getLogger().error("Failed to parse block: " + block + ", encountered Exception", new Object[0]);
            AgriCraft.instance.getLogger().printStackTrace(e);
            return false;
        }
    }

    protected boolean isValidFluid(String fluid, boolean useTag) {
        String[] parts = fluid.split(":");
        if (parts.length != 2) {
            return false;
        }
        if (useTag && TagUtil.isValidTag(FluidTags.func_226157_a_(), fluid)) {
            return true;
        }
        try {
            return ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(parts[0], parts[1]));
        }
        catch (Exception e) {
            AgriCraft.instance.getLogger().error("Failed to parse fluid: " + fluid + ", encountered Exception", new Object[0]);
            AgriCraft.instance.getLogger().printStackTrace(e);
            return false;
        }
    }

    @Override
    public boolean isValidResource(String resource) {
        try {
            if (resource.contains("#")) {
                return new ModelResourceLocation(resource).toString().equalsIgnoreCase(resource);
            }
            return new ResourceLocation(resource).toString().equalsIgnoreCase(resource);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean isValidCallback(String callback) {
        return JsonPlantCallback.get(callback).isPresent();
    }

    @Override
    public boolean isValidHumidity(String humidity) {
        return IAgriSoil.Humidity.fromString(humidity).isPresent();
    }

    @Override
    public boolean isValidAcidity(String acidity) {
        return IAgriSoil.Acidity.fromString(acidity).isPresent();
    }

    @Override
    public boolean isValidNutrients(String nutrients) {
        return IAgriSoil.Nutrients.fromString(nutrients).isPresent();
    }

    @Override
    public boolean isValidMod(String modid) {
        return modid.equals("minecraft") || ModList.get().isLoaded(modid);
    }
}

