/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedBagItem;
import com.infinityraider.agricraft.content.tools.ItemSeedBag;
import com.infinityraider.agricraft.handler.SeedBagShakeHandler;
import com.infinityraider.agricraft.network.MessageSyncSeedBagSortMode;
import com.infinityraider.agricraft.reference.AgriToolTips;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class SeedBagScrollHandler {
    private static final SeedBagScrollHandler INSTANCE = new SeedBagScrollHandler();

    public static SeedBagScrollHandler getInstance() {
        return INSTANCE;
    }

    private SeedBagScrollHandler() {
    }

    public PlayerEntity getPlayer() {
        return AgriCraft.instance.getClientPlayer();
    }

    public boolean tryCycleSortMode(Hand hand, int delta) {
        ItemSeedBag bag;
        ItemStack stack = this.getPlayer().func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemSeedBag && (bag = (ItemSeedBag)stack.func_77973_b()).incrementSorter(stack, delta)) {
            new MessageSyncSeedBagSortMode(hand, bag.getContents(stack).getSorterIndex()).sendToServer();
            SeedBagShakeHandler.getInstance().shake(hand);
            IAgriSeedBagItem.Contents contents = bag.getContents(stack);
            IFormattableTextComponent message = new StringTextComponent("").func_230529_a_(contents.getSorter().describe()).func_230529_a_((ITextComponent)new StringTextComponent(", ")).func_230529_a_(AgriToolTips.MSG_SEED_BAG_SHAKE);
            if (contents.getCount() <= 0) {
                message.func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_(AgriToolTips.MSG_SEED_BAG_EMPTY);
            }
            AgriCraft.instance.getClientPlayer().func_145747_a((ITextComponent)message, Util.field_240973_b_);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        if (this.getPlayer().func_225608_bj_()) {
            int delta = (int)(-event.getScrollDelta());
            boolean main = this.tryCycleSortMode(Hand.MAIN_HAND, delta);
            boolean off = this.tryCycleSortMode(Hand.OFF_HAND, delta);
            if (main || off) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }
}

