/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.irrigation.BlockIrrigationChannelAbstract;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationComponent;
import com.infinityraider.agricraft.render.blocks.TileEntityIrrigationChannelRenderer;
import com.infinityraider.infinitylib.block.tile.InfinityTileEntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityIrrigationChannel
extends TileEntityIrrigationComponent {
    private static final float MIN_Y = 0.375f;
    private static final float MAX_Y = 0.625f;
    private static final int HEIGHT_INTERVALS = 6;
    private static final float CONTENT_DELTA_FRACTION = 0.1f;
    private ValveState state = ValveState.NONE;
    private int counter = 0;

    public TileEntityIrrigationChannel() {
        super(AgriCraft.instance.getModTileRegistry().irrigation_channel, ((Config)AgriCraft.instance.getConfig()).channelCapacity(), 0.375f, 0.625f);
    }

    public static RenderFactory createRenderFactory() {
        return new RenderFactory();
    }

    public boolean hasHandWheel() {
        return ((BlockIrrigationChannelAbstract)this.func_195044_w().func_177230_c()).hasHandWheel();
    }

    public boolean hasValve() {
        return ((BlockIrrigationChannelAbstract.Valve)((Object)BlockIrrigationChannelAbstract.VALVE.fetch(this.func_195044_w()))).hasValve();
    }

    public boolean isOpen() {
        return ((BlockIrrigationChannelAbstract.Valve)((Object)BlockIrrigationChannelAbstract.VALVE.fetch(this.func_195044_w()))).canTransfer();
    }

    public boolean isClosed() {
        return BlockIrrigationChannelAbstract.VALVE.fetch(this.func_195044_w()) == BlockIrrigationChannelAbstract.Valve.CLOSED;
    }

    public void setValveState(ValveState state) {
        this.state = state;
        this.counter = state.getDuration();
    }

    public ValveState getValveState() {
        return this.state;
    }

    public float getValveAnimationProgress(float partialTicks) {
        return this.getValveState().getAnimationProgress(this.counter, partialTicks);
    }

    @Override
    protected void tickComponent() {
        if (this.func_145831_w() != null && this.func_145831_w().func_201670_d() && this.counter > 0) {
            --this.counter;
            if (this.counter <= 0) {
                this.state = this.state.getResult();
            }
        }
    }

    @Override
    protected boolean canConnect(@Nonnull TileEntityIrrigationComponent other) {
        return other.isSameMaterial((TileEntity)this);
    }

    @Override
    protected boolean canTransfer(@Nonnull TileEntityIrrigationComponent other, @Nonnull Direction dir) {
        return this.canConnect(other) && ((BlockIrrigationChannelAbstract.Valve)((Object)BlockIrrigationChannelAbstract.VALVE.fetch(this.func_195044_w()))).canTransfer();
    }

    @Override
    protected int getLevelIntervalCount() {
        return 6;
    }

    @Override
    protected float getContentDeltaFraction() {
        return 0.1f;
    }

    @Override
    protected String description() {
        return "channel";
    }

    private static class RenderFactory
    implements InfinityTileEntityType.IRenderFactory<TileEntityIrrigationChannel> {
        private RenderFactory() {
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public TileEntityIrrigationChannelRenderer createRenderer() {
            return new TileEntityIrrigationChannelRenderer();
        }
    }

    public static enum ValveState {
        NONE(0.0f),
        OPEN(1.0f),
        CLOSED(0.0f),
        OPENING(CLOSED, OPEN, 20),
        CLOSING(OPEN, CLOSED, 20);

        private final float target;
        private final ValveState from;
        private final ValveState to;
        private final int duration;

        private ValveState(float target) {
            this.target = target;
            this.from = this;
            this.to = this;
            this.duration = -1;
        }

        private ValveState(ValveState from, ValveState to, int duration) {
            this.from = from;
            this.to = to;
            this.duration = duration;
            this.target = this.getResult().target;
        }

        public float getAnimationProgress(int counter, float partialTick) {
            if (this.hasAnimation()) {
                return MathHelper.func_219799_g((float)Math.min(1.0f, ((float)counter + partialTick) / (float)this.getDuration()), (float)this.to.target, (float)this.from.target);
            }
            return this.target;
        }

        public ValveState getResult() {
            return this.to;
        }

        public boolean hasAnimation() {
            return this.getDuration() > 0;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

