/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.render.particles.SprinklerParticle;
import com.infinityraider.infinitylib.particle.IInfinityParticleType;
import com.infinityraider.infinitylib.particle.ParticleTypeBase;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class SprinklerParticleType
extends ParticleTypeBase<Data> {
    public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("fluid").forGetter(data -> data.getFluid().getRegistryName().toString()), (App)Codec.FLOAT.fieldOf("scale").forGetter(Data::getScale), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Data::getGravity)).apply((Applicative)instance, (fluid, scale, gravity) -> new Data((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)), scale.floatValue(), gravity.floatValue())));

    public SprinklerParticleType() {
        super("sprinkler_particle", true);
    }

    public Data createParticleData(Fluid fluid, float scale, float gravity) {
        return new Data(fluid, scale, gravity);
    }

    public Data deserializeData(@Nonnull StringReader reader) throws CommandSyntaxException {
        reader.expect(' ');
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(reader.readStringUntil(' ')));
        reader.expect(' ');
        float scale = reader.readFloat();
        reader.expect(' ');
        float gravity = reader.readFloat();
        if (fluid == null) {
            throw new SimpleCommandExceptionType(() -> "Invalid Fluid key").create();
        }
        return new Data(fluid, scale, gravity);
    }

    public Data readData(@Nonnull PacketBuffer buffer) {
        return new Data((Fluid)ForgeRegistries.FLUIDS.getValue(buffer.func_192575_l()), buffer.readFloat(), buffer.readFloat());
    }

    @Nonnull
    public IInfinityParticleType.ParticleFactorySupplier<Data> particleFactorySupplier() {
        return new FactorySupplier();
    }

    @Nonnull
    public Codec<Data> func_230522_e_() {
        return CODEC;
    }

    private static final class FactorySupplier
    implements IInfinityParticleType.ParticleFactorySupplier<Data> {
        private FactorySupplier() {
        }

        @OnlyIn(value=Dist.CLIENT)
        public IParticleFactory<Data> supplyFactory() {
            return (data, world, x, y, z, vX, vY, vZ) -> new SprinklerParticle(world, data.getFluid(), x, y, z, data.getScale(), data.getGravity(), new Vector3d(vX, vY, vZ));
        }
    }

    public static class Data
    implements IParticleData {
        private final Fluid fluid;
        private final float scale;
        private final float gravity;

        public Fluid getFluid() {
            return this.fluid;
        }

        public float getScale() {
            return this.scale;
        }

        public float getGravity() {
            return this.gravity;
        }

        public Data(Fluid fluid, float scale, float gravity) {
            this.fluid = fluid;
            this.scale = scale;
            this.gravity = gravity;
        }

        @Nonnull
        public ParticleType<?> func_197554_b() {
            return AgriCraft.instance.getModParticleRegistry().sprinkler;
        }

        public void func_197553_a(@Nonnull PacketBuffer buffer) {
            buffer.func_192572_a(Objects.requireNonNull(this.getFluid().getRegistryName()));
            buffer.writeFloat(this.getScale());
            buffer.writeFloat(this.getGravity());
        }

        @Nonnull
        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %f %f", Objects.requireNonNull(this.getFluid().getRegistryName()).toString(), Float.valueOf(this.getScale()), Float.valueOf(this.getGravity()));
        }
    }
}

