/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.google.common.collect.Lists;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedItem;
import com.infinityraider.agricraft.content.core.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.reference.AgriToolTips;
import com.infinityraider.infinitylib.block.BlockBaseTile;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.block.property.InfPropertyConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockSeedAnalyzer
extends BlockBaseTile<TileEntitySeedAnalyzer>
implements IWaterLoggable {
    public static final InfProperty<Direction> ORIENTATION = InfProperty.Creators.createHorizontals((String)"orientation", (Direction)Direction.NORTH);
    public static final InfProperty<Boolean> JOURNAL = InfProperty.Creators.create((String)"journal", (boolean)false);
    private static final InfPropertyConfiguration PROPERTIES = InfPropertyConfiguration.builder().add(ORIENTATION).add(JOURNAL).waterloggable().build();
    private static final BiFunction<BlockState, IBlockReader, TileEntitySeedAnalyzer> TILE_FACTORY = (s, w) -> new TileEntitySeedAnalyzer();
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);

    public BlockSeedAnalyzer() {
        super("seed_analyzer", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_());
    }

    protected InfPropertyConfiguration getPropertyConfiguration() {
        return PROPERTIES;
    }

    public BiFunction<BlockState, IBlockReader, TileEntitySeedAnalyzer> getTileEntityFactory() {
        return TILE_FACTORY;
    }

    public Item func_199767_j() {
        return AgriCraft.instance.getModItemRegistry().seed_analyzer;
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220071_b(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_230322_a_(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState current = world.func_180495_p(pos);
        return current.func_185904_a().func_76222_j();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        if (state.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) {
            return ORIENTATION.apply(this.fluidlog(state, context.func_195991_k(), context.func_195995_a()), (Comparable)context.func_195992_f().func_176734_d());
        }
        return null;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.FAIL;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntitySeedAnalyzer)) {
            return ActionResultType.FAIL;
        }
        TileEntitySeedAnalyzer analyzer = (TileEntitySeedAnalyzer)tile;
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (world.func_201670_d()) {
                return ActionResultType.PASS;
            }
            if (analyzer.hasSeed()) {
                this.extractSeed(analyzer, player);
                return ActionResultType.CONSUME;
            }
            if (heldItem.func_77973_b() instanceof IAgriSeedItem) {
                player.func_184586_b(hand).func_190920_e(analyzer.insertSeed(heldItem).func_190916_E());
                return ActionResultType.CONSUME;
            }
            if (analyzer.hasJournal()) {
                if (heldItem.func_190926_b()) {
                    this.extractJournal(analyzer, player);
                    return ActionResultType.CONSUME;
                }
                return ActionResultType.FAIL;
            }
            if (heldItem.func_77973_b() instanceof IAgriJournalItem) {
                if (analyzer.insertJournal(heldItem).func_190926_b()) {
                    heldItem.func_190918_g(1);
                }
                return ActionResultType.CONSUME;
            }
            return ActionResultType.FAIL;
        }
        if (world.func_201670_d() && !analyzer.isObserved()) {
            if (this.isViewBlocked(world, pos, (Direction)ORIENTATION.fetch(state))) {
                player.func_145747_a(AgriToolTips.MSG_ANALYZER_VIEW_BLOCKED, Util.field_240973_b_);
            } else {
                analyzer.setObserving(true);
            }
        }
        return ActionResultType.CONSUME;
    }

    public void extractSeed(TileEntitySeedAnalyzer analyzer, @Nullable PlayerEntity player) {
        if (analyzer.hasSeed()) {
            ItemStack seed = analyzer.extractSeed();
            if (!(player != null && player.func_191521_c(seed) || analyzer.func_145831_w() == null)) {
                this.spawnItem(analyzer.func_145831_w(), analyzer.func_174877_v(), seed);
            }
        }
    }

    public void extractJournal(TileEntitySeedAnalyzer analyzer, @Nullable PlayerEntity player) {
        if (analyzer.hasJournal()) {
            ItemStack journal = analyzer.extractJournal();
            if (!(player != null && player.func_191521_c(journal) || analyzer.func_145831_w() == null)) {
                this.spawnItem(analyzer.func_145831_w(), analyzer.func_174877_v(), journal);
            }
        }
    }

    protected boolean isViewBlocked(World world, BlockPos pos, Direction orientation) {
        BlockPos up = pos.func_177984_a();
        if (!world.func_175623_d(up)) {
            return true;
        }
        BlockPos front = pos.func_177972_a(orientation);
        if (!world.func_175623_d(front)) {
            return true;
        }
        return !world.func_175623_d(front.func_177984_a());
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder context) {
        ArrayList drops = Lists.newArrayList();
        drops.add(new ItemStack((IItemProvider)AgriCraft.instance.getModItemRegistry().seed_analyzer));
        TileEntity tile = (TileEntity)context.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof TileEntitySeedAnalyzer) {
            TileEntitySeedAnalyzer analyzer = (TileEntitySeedAnalyzer)tile;
            if (analyzer.hasSeed()) {
                drops.add(analyzer.getSeed());
            }
            if (analyzer.hasJournal()) {
                drops.add(analyzer.getJournal());
            }
        }
        return drops;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderType getRenderType() {
        return RenderType.func_228643_e_();
    }
}

