/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.capability;

import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.world.GreenHouse;
import com.infinityraider.infinitylib.capability.IInfSerializableCapabilityImplementation;
import com.infinityraider.infinitylib.utility.ISerializable;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityGreenHouseData
implements IInfSerializableCapabilityImplementation<Chunk, Impl> {
    private static final CapabilityGreenHouseData INSTANCE = new CapabilityGreenHouseData();
    public static ResourceLocation KEY = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "greenhouse");
    @CapabilityInject(value=Impl.class)
    public static final Capability<Impl> CAPABILITY = null;

    public static CapabilityGreenHouseData getInstance() {
        return INSTANCE;
    }

    private CapabilityGreenHouseData() {
    }

    public void addGreenHouse(World world, GreenHouse greenHouse) {
        greenHouse.getChunks().stream().map(pos -> world.func_212866_a_(pos.field_77276_a, pos.field_77275_b)).map(arg_0 -> ((CapabilityGreenHouseData)this).getCapability(arg_0)).map(LazyOptional::resolve).filter(Optional::isPresent).map(Optional::get).forEach(impl -> impl.add(greenHouse));
    }

    public Class<Impl> getCapabilityClass() {
        return Impl.class;
    }

    public Capability<Impl> getCapability() {
        return CAPABILITY;
    }

    public boolean shouldApplyCapability(Chunk carrier) {
        return true;
    }

    public Impl createNewValue(Chunk carrier) {
        return new Impl(carrier);
    }

    public ResourceLocation getCapabilityKey() {
        return KEY;
    }

    public Class<Chunk> getCarrierClass() {
        return Chunk.class;
    }

    public static class Impl
    implements ISerializable {
        private final Chunk chunk;
        private final Set<GreenHouse.Part> greenhouses;

        protected Impl(Chunk chunk) {
            this.chunk = chunk;
            this.greenhouses = Sets.newIdentityHashSet();
        }

        public Chunk getChunk() {
            return this.chunk;
        }

        public ChunkPos getChunkPos() {
            return this.getChunk().func_76632_l();
        }

        protected void add(GreenHouse greenHouse) {
            this.greenhouses.add(greenHouse.getPart(this.getChunkPos()));
        }

        public void readFromNBT(CompoundNBT tag) {
        }

        public CompoundNBT writeToNBT() {
            ListNBT entries = new ListNBT();
            this.greenhouses.stream().map(GreenHouse.Part::writeToTag).forEach(arg_0 -> entries.add(arg_0));
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("agri_entries", (INBT)entries);
            return tag;
        }
    }
}

