/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.plant;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAllele;
import com.infinityraider.agricraft.api.v1.plant.AgriPlantIngredient;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatsMap;
import com.infinityraider.agricraft.api.v1.util.IAgriRegisterable;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public interface IAgriPlant
extends IAgriRegisterable<IAgriPlant>,
IAgriGrowable.WithSeed,
IAllele<IAgriPlant> {
    default public AgriPlantIngredient toIngredient() {
        return new AgriPlantIngredient(this);
    }

    default public ItemStack toItemStack() {
        return this.toItemStack(1);
    }

    default public ItemStack toItemStack(int amount) {
        return AgriApi.plantToSeedStack(this, amount);
    }

    @Nonnull
    public IFormattableTextComponent getPlantName();

    @Nonnull
    public IFormattableTextComponent getSeedName();

    public int getTier();

    public boolean isFertilizable(IAgriGrowthStage var1, IAgriFertilizer var2);

    public double getSpreadChance(IAgriGrowthStage var1);

    public double getGrowthChanceBase(IAgriGrowthStage var1);

    public double getGrowthChanceBonus(IAgriGrowthStage var1);

    public double getSeedDropChanceBase(IAgriGrowthStage var1);

    public double getSeedDropChanceBonus(IAgriGrowthStage var1);

    @Nonnull
    public IAgriGrowthStage getGrowthStageAfterHarvest();

    public Optional<BlockState> asBlockState(IAgriGrowthStage var1);

    @Nonnull
    public IFormattableTextComponent getInformation();

    public void addTooltip(Consumer<ITextComponent> var1);

    @Nonnull
    public Collection<ItemStack> getSeedItems();

    @Nonnull
    public IAgriGrowthRequirement getGrowthRequirement(IAgriGrowthStage var1);

    public void getAllPossibleProducts(@Nonnull Consumer<ItemStack> var1);

    public void getHarvestProducts(@Nonnull Consumer<ItemStack> var1, @Nonnull IAgriGrowthStage var2, @Nonnull IAgriStatsMap var3, @Nonnull Random var4);

    public void getAllPossibleClipProducts(@Nonnull Consumer<ItemStack> var1);

    public void getClipProducts(@Nonnull Consumer<ItemStack> var1, @Nonnull ItemStack var2, @Nonnull IAgriGrowthStage var3, @Nonnull IAgriStatsMap var4, @Nonnull Random var5);

    public boolean allowsCloning(IAgriGrowthStage var1);

    public void spawnParticles(@Nonnull IAgriCrop var1, Random var2);

    default public boolean allowsHarvest(@Nonnull IAgriGrowthStage stage, @Nullable LivingEntity entity) {
        return stage.isMature();
    }

    default public boolean allowsClipping(@Nonnull IAgriGrowthStage stage, @Nonnull ItemStack clipper, @Nullable LivingEntity entity) {
        return stage.isMature();
    }

    default public int getBrightness(@Nonnull IAgriCrop crop) {
        return 0;
    }

    default public int getRedstonePower(@Nonnull IAgriCrop crop) {
        return 0;
    }

    default public void onPlanted(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
    }

    default public void onSpawned(@Nonnull IAgriCrop crop) {
    }

    default public void onGrowth(@Nonnull IAgriCrop crop) {
    }

    default public void onRemoved(@Nonnull IAgriCrop crop) {
    }

    default public void onHarvest(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
    }

    default public void onClipped(@Nonnull IAgriCrop crop, @Nonnull ItemStack clipper, @Nullable LivingEntity entity) {
    }

    default public void onBroken(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
    }

    default public void onEntityCollision(@Nonnull IAgriCrop crop, Entity entity) {
    }

    default public boolean isPlant() {
        return true;
    }

    @Override
    default public IAgriGene<IAgriPlant> gene() {
        return AgriApi.getGeneRegistry().getPlantGene();
    }

    @Override
    default public IAgriPlant trait() {
        return this;
    }

    @Override
    default public boolean isDominant(IAllele<IAgriPlant> other) {
        int b;
        if (!this.isPlant()) {
            return false;
        }
        if (!other.trait().isPlant()) {
            return true;
        }
        if (this.equals(other)) {
            return true;
        }
        int a = AgriApi.getMutationRegistry().complexity(this);
        if (a == (b = AgriApi.getMutationRegistry().complexity(other.trait()))) {
            return this.getId().compareTo(other.trait().getId()) < 0;
        }
        return a > b;
    }

    @Override
    default public int comparatorValue() {
        return 0;
    }

    @Override
    @Nonnull
    default public CompoundNBT writeToNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("agri_plant", this.getId());
        return tag;
    }

    @Override
    default public IFormattableTextComponent getTooltip() {
        return this.getPlantName();
    }
}

