/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.client;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.client.IAgriPlantQuadGenerator;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;

@OnlyIn(value=Dist.CLIENT)
public enum AgriPlantRenderType implements IExtensibleEnum
{
    HASH(Identifiers.hash(), (plant, stage, dir, sprite) -> AgriPlantRenderType.plantQuadGenerator().bakeQuadsForHashPattern(plant, stage, dir, sprite)),
    CROSS(Identifiers.cross(), (plant, stage, dir, sprite) -> AgriPlantRenderType.plantQuadGenerator().bakeQuadsForCrossPattern(plant, stage, dir, sprite)),
    PLUS(Identifiers.plus(), (plant, stage, dir, sprite) -> AgriPlantRenderType.plantQuadGenerator().bakeQuadsForPlusPattern(plant, stage, dir, sprite)),
    RHOMBUS(Identifiers.rhombus(), (plant, stage, dir, sprite) -> AgriPlantRenderType.plantQuadGenerator().bakeQuadsForRhombusPattern(plant, stage, dir, sprite)),
    GOURD(Identifiers.gourd(), (plant, stage, dir, sprite) -> AgriPlantRenderType.plantQuadGenerator().bakeQuadsForGourdPattern(plant, stage, dir, sprite));

    private final Predicate<String> nameFilter;
    private final IQuadGenerator generator;

    private AgriPlantRenderType(Predicate<String> nameFilter, IQuadGenerator generator) {
        this.nameFilter = nameFilter;
        this.generator = generator;
    }

    public boolean matches(String id) {
        return this.nameFilter.test(id);
    }

    @Nonnull
    public List<BakedQuad> bakedQuads(IAgriGrowable plant, IAgriGrowthStage stage, @Nullable Direction direction, IntFunction<TextureAtlasSprite> spriteFunc) {
        return this.generator.bakeQuads(plant, stage, direction, spriteFunc);
    }

    public static AgriPlantRenderType create(String name, Predicate<String> nameFilter, IQuadGenerator generator) {
        throw new IllegalStateException("Enum not extended");
    }

    public static Optional<AgriPlantRenderType> fetchFromIdentifier(String id) {
        return Arrays.stream(AgriPlantRenderType.values()).filter(type -> type.matches(id)).findAny();
    }

    public static IAgriPlantQuadGenerator plantQuadGenerator() {
        return IAgriPlantQuadGenerator.getInstance();
    }

    public static final class Identifiers {
        public static final List<String> HASH = ImmutableList.of((Object)"hash", (Object)"#");
        public static final List<String> CROSS = ImmutableList.of((Object)"cross", (Object)"X");
        public static final List<String> PLUS = ImmutableList.of((Object)"plus", (Object)"+");
        public static final List<String> RHOMBUS = ImmutableList.of((Object)"rhombus", (Object)"\u00e2\u00ac\u00a6", (Object)"\u00e2\u2014\u2021");
        public static final List<String> GOURD = ImmutableList.of((Object)"gourd", (Object)"@");

        public static Predicate<String> predicate(List<String> entries) {
            return string -> entries.stream().anyMatch(entry -> entry.equalsIgnoreCase((String)string));
        }

        public static Predicate<String> hash() {
            return Identifiers.predicate(HASH);
        }

        public static Predicate<String> cross() {
            return Identifiers.predicate(CROSS);
        }

        public static Predicate<String> plus() {
            return Identifiers.predicate(PLUS);
        }

        public static Predicate<String> rhombus() {
            return Identifiers.predicate(RHOMBUS);
        }

        public static Predicate<String> gourd() {
            return Identifiers.predicate(GOURD);
        }

        private Identifiers() throws IllegalAccessException {
            throw new IllegalAccessException("Whomst dareth init?");
        }
    }

    @FunctionalInterface
    public static interface IQuadGenerator {
        @Nonnull
        public List<BakedQuad> bakeQuads(IAgriGrowable var1, IAgriGrowthStage var2, @Nullable Direction var3, IntFunction<TextureAtlasSprite> var4);
    }
}

