/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1;

import com.infinityraider.agricraft.api.v1.AgriApiState;
import com.infinityraider.agricraft.api.v1.IAgriApiConnector;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import com.infinityraider.agricraft.api.v1.client.IAgriPlantQuadGenerator;
import com.infinityraider.agricraft.api.v1.client.IMagnifyingGlassInspector;
import com.infinityraider.agricraft.api.v1.config.IAgriConfig;
import com.infinityraider.agricraft.api.v1.content.IAgriContent;
import com.infinityraider.agricraft.api.v1.crop.CropCapability;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneRegistry;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationHandler;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.plant.AgriPlantIngredient;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowthRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlantRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeedRegistry;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import com.infinityraider.agricraft.api.v1.requirement.AnySoilIngredient;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSeasonLogic;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoilRegistry;
import com.infinityraider.agricraft.api.v1.requirement.IDefaultGrowConditionFactory;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class AgriApi {
    public static final String MOD_ID = "agricraft";
    public static final String API_ID = "agricraft-api-v1";
    private static final IAgriApiConnector CONNECTOR = AgriApi.connect();

    @Nonnull
    public static AgriApiState getState() {
        return CONNECTOR.getState();
    }

    @Nonnull
    public static IAgriContent getAgriContent() {
        return CONNECTOR.connectAgriContent();
    }

    @Nonnull
    public static IAgriConfig getAgriConfig() {
        return CONNECTOR.connectAgriConfig();
    }

    @Nonnull
    public static IAgriPlantRegistry getPlantRegistry() {
        return CONNECTOR.connectPlantRegistry();
    }

    @Nonnull
    public static IAgriWeedRegistry getWeedRegistry() {
        return CONNECTOR.connectWeedRegistry();
    }

    @Nonnull
    public static IAgriGrowthRegistry getGrowthStageRegistry() {
        return CONNECTOR.connectGrowthStageRegistry();
    }

    @Nonnull
    public static IAgriMutationRegistry getMutationRegistry() {
        return CONNECTOR.connectMutationRegistry();
    }

    @Nonnull
    public static IAgriGeneRegistry getGeneRegistry() {
        return CONNECTOR.connectGeneRegistry();
    }

    @Nonnull
    public static IAgriStatRegistry getStatRegistry() {
        return CONNECTOR.connectStatRegistry();
    }

    @Nonnull
    public static IAgriSoilRegistry getSoilRegistry() {
        return CONNECTOR.connectSoilRegistry();
    }

    @Nonnull
    public static IAgriAdapterizer<IAgriGenome> getGenomeAdapterizer() {
        return CONNECTOR.connectGenomeAdapterizer();
    }

    @Nonnull
    public static IAgriAdapterizer<IAgriFertilizer> getFertilizerAdapterizer() {
        return CONNECTOR.connectFertilizerRegistry();
    }

    @Nonnull
    public static IAgriSeasonLogic getSeasonLogic() {
        return CONNECTOR.connectSeasonLogic();
    }

    @Nonnull
    public static ItemStack plantToSeedStack(IAgriPlant plant, int amount) {
        return CONNECTOR.plantToSeedStack(plant, amount);
    }

    @Nonnull
    public static IIngredientSerializer<AgriPlantIngredient> getPlantIngredientSerializer() {
        return CONNECTOR.connectPlantIngredientSerializer();
    }

    @Nonnull
    public static IIngredientSerializer<AnySoilIngredient> getAnySoilIngredientSerializer() {
        return CONNECTOR.connectAnySoilIngredientSerializer();
    }

    @Nonnull
    public static Optional<IAgriCrop> getCrop(IBlockReader world, BlockPos pos) {
        return CONNECTOR.getCrop(world, pos);
    }

    @Nonnull
    public static Optional<IAgriSoil> getSoil(IBlockReader world, BlockPos pos) {
        return CONNECTOR.getSoil(world, pos);
    }

    @Nonnull
    public static Optional<IAgriFertilizer> getFertilizer(ItemStack itemStack) {
        return CONNECTOR.getFertilizer(itemStack);
    }

    @Nonnull
    public static ItemStack attemptConversionToAgriSeed(ItemStack original) {
        return CONNECTOR.attemptConversionToAgriSeed(original);
    }

    public static void registerVanillaPlantingOverrideException(Item seed) {
        CONNECTOR.registerVanillaPlantingOverrideException(seed);
    }

    public static <T extends TileEntity, C extends IAgriCrop> void registerCapabilityCropInstance(CropCapability.Instance<T, C> instance) {
        CONNECTOR.registerCapabilityCropInstance(instance);
    }

    @Nonnull
    public static IAgriGrowthRequirement.Builder getGrowthRequirementBuilder() {
        return CONNECTOR.getGrowthRequirementBuilder();
    }

    @Nonnull
    public static IDefaultGrowConditionFactory getDefaultGrowConditionFactory() {
        return CONNECTOR.getDefaultGrowConditionFactory();
    }

    @Nonnull
    public static List<IAgriGrowthStage> getDefaultGrowthStages(int stages) {
        return CONNECTOR.getDefaultGrowthStages(stages);
    }

    @Nonnull
    public static IAgriMutationHandler getAgriMutationHandler() {
        return CONNECTOR.getAgriMutationHandler();
    }

    @Nonnull
    public static IAgriGenome.Builder getAgriGenomeBuilder(@Nonnull IAgriPlant plant) {
        return CONNECTOR.getAgriGenomeBuilder(plant);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static IAgriPlantQuadGenerator getPlantQuadGenerator() {
        return CONNECTOR.getPlantQuadGenerator();
    }

    @Nonnull
    public static Optional<IJsonPlantCallback> getJsonPlantCallback(String id) {
        return CONNECTOR.getJsonPlantCallback(id);
    }

    public static boolean registerJsonPlantCallback(@Nonnull IJsonPlantCallback callback) {
        return CONNECTOR.registerJsonPlantCallback(callback);
    }

    public static boolean isObservingWithMagnifyingGlass(PlayerEntity player) {
        return CONNECTOR.isObservingWithMagnifyingGlass(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerMagnifyingGlassInspector(IMagnifyingGlassInspector inspector) {
        CONNECTOR.registerMagnifyingGlassInspector(inspector);
    }

    @Nonnull
    private static IAgriApiConnector connect() {
        IAgriApiConnector instance;
        Constructor<IAgriApiConnector> constructor;
        Class<IAgriApiConnector> clazz;
        Logger logger = LogManager.getLogger();
        Marker marker = MarkerManager.getMarker((String)API_ID);
        try {
            clazz = Class.forName("com.infinityraider.agricraft.impl.v1.AgriApiConnector").asSubclass(IAgriApiConnector.class);
        }
        catch (ClassNotFoundException exception) {
            logger.log(Level.INFO, marker, "The AgriCraft APIv1 was unable find AgriCraft! Is AgriCraft missing from your modpack?");
            return IAgriApiConnector.FAKE;
        }
        catch (ClassCastException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, but instead found an invalid class! This is a serious error that should never happen! Report this error immediately!", exception);
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, found a connection class, but couldn't find a valid no-args constructor! This is a serious error that should never happen! Report this error immediately!", exception);
        }
        catch (SecurityException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, but instead ran into a security exception! This is a very unusual error that should not have happened! Report this error immediately!", exception);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, but instead was prevented from accessing the constructor required to create a connection! This is a very unusual error that should not have happened! Report this error immediately!", exception);
        }
        catch (IllegalArgumentException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, but instead discovered something is wrong with the JVM! This error should never occur! Report this error immediately to Oracle!", exception);
        }
        catch (InstantiationException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, found a connection class, but it was abstract! This is a serious error that should never happen! Report this error immediately!", exception);
        }
        catch (InvocationTargetException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, found a valid connection class, started instantiation, but then the AgriApi.connector threw an error! This is a serious error that should never happen! Report this error immediately!", exception);
        }
        logger.log(Level.INFO, marker, "The AgriCraft APIv1 successfully connected to AgriCraft! Thank you for including AgriCraft in your modpack!");
        return instance;
    }

    private AgriApi() {
    }
}

