/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.util;

import com.agricraft.agricore.core.AgriCore;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.util.ConfigurationBuilder;

public class ResourceHelper {
    private final Reflections reflections;

    public static void copyResources(Stream<Path> pathStream, Predicate<String> nameFilter, Predicate<String> dirFilter, Function<String, Path> toFunction, boolean overwrite) {
        ResourceHelper helper = new ResourceHelper(ResourceHelper.collectURLs(pathStream));
        helper.findResources(nameFilter).stream().filter(dirFilter).forEach(r -> helper.copyResource((String)r, (Path)toFunction.apply((String)r), overwrite));
    }

    private static Collection<URL> collectURLs(Stream<Path> pathStream) {
        return pathStream.map(Path::toUri).map(uri -> {
            URL url = null;
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                AgriCore.getLogger("AgriCraft").error("Unable to scan path", new Object[0]);
                AgriCore.getLogger("AgriCraft").trace(e);
            }
            return url;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected ResourceHelper(Collection<URL> urls) {
        if (Reflections.log != null) {
            Reflections.log = null;
        }
        this.reflections = new Reflections(new ConfigurationBuilder().addScanners(new ResourcesScanner()).addUrls(urls));
    }

    protected Set<String> findResources(Predicate<String> nameFilter) {
        return this.reflections.getResources((com.google.common.base.Predicate<String>)((com.google.common.base.Predicate)nameFilter::test));
    }

    protected void copyResource(String from, Path to, boolean overwrite) {
        try {
            if (overwrite || !Files.exists(to, new LinkOption[0])) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
                Files.copy(this.getResourceAsStream(from), to, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            AgriCore.getLogger("AgriCraft").error("Unable to copy Jar resource: \"{0}\" to: \"{1}\"!", from, to);
            e.printStackTrace();
        }
    }

    protected InputStream getResourceAsStream(String location) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        return in != null ? in : ResourceHelper.class.getResourceAsStream(location);
    }
}

