/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.registry;

import com.agricraft.agricore.json.AgriJsonVersion;
import com.agricraft.agricore.plant.AgriWeed;
import com.agricraft.agricore.plant.versions.v2.Versions_1_16;
import com.agricraft.agricore.registry.AgriLoadableRegistry;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;

public class AgriWeeds
implements AgriLoadableRegistry<AgriWeed> {
    private final Map<String, AgriWeed> weeds = new HashMap<String, AgriWeed>();

    public boolean hasWeed(String id) {
        return this.weeds.containsKey(id);
    }

    public boolean addWeed(AgriWeed plant) {
        return this.weeds.putIfAbsent(plant.getId(), plant) == null;
    }

    public AgriWeed getWeed(String id) {
        return this.weeds.get(id);
    }

    public ImmutableSet<AgriWeed> getAllElements() {
        return ImmutableSet.copyOf(this.weeds.values());
    }

    public void validate() {
        this.weeds.entrySet().removeIf(e -> !((AgriWeed)e.getValue()).validate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nWeeds:");
        for (AgriWeed weed : this.weeds.values()) {
            sb.append("\n\t- Plant: ");
            sb.append(weed.toString().replaceAll("\n", "\n\t").trim());
        }
        return sb.append("\n").toString();
    }

    @Override
    public boolean acceptsElement(String filename) {
        return filename.toLowerCase().endsWith("_weed.json");
    }

    @Override
    public AgriJsonVersion<AgriWeed> getElementVersion() {
        return Versions_1_16.WEED;
    }

    @Override
    public void registerElement(AgriWeed element) {
        this.addWeed(element);
    }

    @Override
    public void clearElements() {
        this.weeds.clear();
    }

    public int hashCode() {
        return this.weeds.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgriWeeds other = (AgriWeeds)obj;
        return this.weeds.equals(other.weeds);
    }
}

