/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant.fertilizer;

import com.agricraft.agricore.core.AgriCore;
import java.util.Collections;
import java.util.List;

public class AgriPlantList {
    private final boolean blacklist;
    private final List<String> plant_list;

    public AgriPlantList() {
        this(true, Collections.emptyList());
    }

    public AgriPlantList(boolean blacklist, List<String> plant_list) {
        this.blacklist = blacklist;
        this.plant_list = plant_list;
    }

    public boolean isAffected(String plantId) {
        if (this.plant_list.contains(plantId)) {
            return !this.blacklist;
        }
        return this.blacklist;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nAgriPlantList:");
        sb.append("\n\t- Blacklist: ").append(this.blacklist);
        sb.append("\n\t- Plant List: ").append(this.plant_list.stream().collect(StringBuilder::new, (builder, item) -> builder.append("\n\t").append((String)item), StringBuilder::append).toString().replaceAll("\n", "\n\t").trim());
        return sb.toString();
    }

    public boolean validate() {
        if (!this.blacklist) {
            for (String plantId : this.plant_list) {
                if (!AgriCore.getPlants().hasPlant(plantId)) continue;
                return true;
            }
            AgriCore.getCoreLogger().info("Invalid Whitelist : The list does not contains valid plants!", new Object[0]);
        }
        return true;
    }
}

