/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriSerializable;
import com.agricraft.agricore.plant.AgriPlant;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;

public class AgriMutation
implements AgriSerializable,
Comparable<AgriMutation> {
    private String path;
    private final String version;
    private final String json_documentation = "https://agridocs.readthedocs.io/en/master/agri_mutation/";
    private final boolean enabled;
    private final List<String> mods;
    private final double chance;
    private final String child;
    private final String parent1;
    private final String parent2;

    public AgriMutation() {
        this.enabled = false;
        this.mods = Lists.newArrayList((Object[])new String[]{"agricraft", "minecraft"});
        this.path = "default/default_mutation.json";
        this.chance = 0.0;
        this.child = "carrot_plant";
        this.parent1 = "wheat_plant";
        this.parent2 = "potato_plant";
        this.version = "1.16.4";
    }

    public AgriMutation(double chance, String child, String parent1, String parent2, String path, boolean enabled) {
        this(chance, child, parent1, parent2, path, enabled, Lists.newArrayList((Object[])new String[]{"agricraft", "minecraft"}));
    }

    public AgriMutation(double chance, String child, String parent1, String parent2, String path, boolean enabled, List<String> mods) {
        this.enabled = enabled;
        this.mods = mods;
        this.path = path;
        this.chance = chance;
        this.child = child;
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.version = "1.16.4";
    }

    public boolean isChild(String child) {
        return this.child.equals(child);
    }

    public boolean isParent(String parent) {
        return this.parent1.equals(parent) || this.parent2.equals(parent);
    }

    public double getChance() {
        return this.chance;
    }

    public AgriPlant getChild() {
        return AgriCore.getPlants().getPlant(this.child);
    }

    public AgriPlant getParent1() {
        return AgriCore.getPlants().getPlant(this.parent1);
    }

    public AgriPlant getParent2() {
        return AgriCore.getPlants().getPlant(this.parent2);
    }

    public boolean randomMutate(Random rand) {
        return this.chance > rand.nextDouble();
    }

    public boolean validate() {
        if (!this.enabled) {
            AgriCore.getCoreLogger().info("Disabled Mutation: {0}", this);
            return false;
        }
        if (!AgriCore.getPlants().hasPlant(this.child)) {
            AgriCore.getCoreLogger().info("Invalid Mutation: Invalid Child: \"{0}\"!\n{1}", this.child, this);
            return false;
        }
        if (!AgriCore.getPlants().hasPlant(this.parent1)) {
            AgriCore.getCoreLogger().info("Invalid Mutation: Invalid Parent 1: \"{0}\"!\n{1}", this.parent1, this);
            return false;
        }
        if (!AgriCore.getPlants().hasPlant(this.parent2)) {
            AgriCore.getCoreLogger().info("Invalid Mutation: Invalid Parent 2: \"{0}\"!\n{1}", this.parent2, this);
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\nMutation:\n");
        sb.append("\t- Parents:\n");
        sb.append("\t\t- Parent 1: ").append(this.parent1).append("\n");
        sb.append("\t\t- Parent 2: ").append(this.parent2).append("\n");
        sb.append("\t- Child: ").append(this.child).append("\n");
        sb.append("\t- Chance: ").append(this.chance).append("\n");
        return sb.toString();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean checkMods() {
        return this.mods.stream().allMatch(mod -> AgriCore.getValidator().isValidMod((String)mod));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(AgriMutation o) {
        return this.getPath().compareTo(o.getPath());
    }
}

