/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.mixin;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PotionEntity.class})
public abstract class PotionEntityMixin
extends Entity {
    public PotionEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(at={@At(value="TAIL")}, method={"extinguishFires(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Direction;)V"})
    private void extinguishFires(BlockPos pos, Direction direction, CallbackInfo ci) {
        TileEntity tile;
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_177230_c() instanceof DynamicSlabBlock && (tile = this.field_70170_p.func_175625_s(pos)) instanceof SlabTileEntity) {
            SlabTileEntity slab = (SlabTileEntity)tile;
            this.extinguishFires(pos, direction, slab.getPositiveBlockInfo());
            this.extinguishFires(pos, direction, slab.getNegativeBlockInfo());
        }
    }

    private void extinguishFires(BlockPos pos, Direction direction, IBlockInfo block) {
        BlockState blockstate = block.getBlockState();
        if (blockstate == null) {
            return;
        }
        if (blockstate.func_235714_a_((ITag)BlockTags.field_232872_am_)) {
            this.field_70170_p.func_217377_a(pos, false);
        } else if (CampfireBlock.func_226915_i_((BlockState)blockstate)) {
            this.field_70170_p.func_217378_a(null, 1009, pos, 0);
            CampfireBlock.func_235475_c_((IWorld)block.getWorld(), (BlockPos)pos, (BlockState)blockstate);
            block.setBlockState((BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.FALSE));
        }
    }
}

