/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.tileentity;

import cjminecraft.doubleslabs.api.BlockInfo;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.IStateContainer;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.common.init.DSTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class SlabTileEntity
extends TileEntity
implements IStateContainer,
ITickableTileEntity {
    protected final BlockInfo negativeBlockInfo = new BlockInfo(this, false);
    protected final BlockInfo positiveBlockInfo = new BlockInfo(this, true);

    public SlabTileEntity() {
        super((TileEntityType)DSTiles.DYNAMIC_SLAB.get());
    }

    protected SlabTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.negativeBlockInfo.deserializeNBT(nbt.func_74775_l("negativeBlock"));
        this.positiveBlockInfo.deserializeNBT(nbt.func_74775_l("positiveBlock"));
        super.func_230337_a_(state, nbt);
        this.markDirtyClient();
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("negativeBlock", (INBT)this.negativeBlockInfo.serializeNBT());
        nbt.func_218657_a("positiveBlock", (INBT)this.positiveBlockInfo.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.func_230337_a_(state, tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public CompoundNBT getTileData() {
        return this.func_189515_b(new CompoundNBT());
    }

    protected void markDirtyFast() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public void markDirtyClient() {
        this.func_70296_d();
        this.requestModelDataUpdate();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
        }
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.negativeBlockInfo.setWorld(world);
        this.positiveBlockInfo.setWorld(world);
    }

    @Override
    public IBlockInfo getPositiveBlockInfo() {
        return this.positiveBlockInfo;
    }

    @Override
    public IBlockInfo getNegativeBlockInfo() {
        return this.negativeBlockInfo;
    }

    public void onLoad() {
        this.negativeBlockInfo.onLoad();
        this.positiveBlockInfo.onLoad();
    }

    public void onChunkUnloaded() {
        this.negativeBlockInfo.onChunkUnloaded();
        this.positiveBlockInfo.onChunkUnloaded();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.negativeBlockInfo.remove();
        this.positiveBlockInfo.remove();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.negativeBlockInfo.validate();
        this.positiveBlockInfo.validate();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.negativeBlockInfo.updateContainingBlockInfo();
        this.positiveBlockInfo.updateContainingBlockInfo();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        LazyOptional<T> negativeCapability = this.negativeBlockInfo.getCapability(cap);
        return negativeCapability.isPresent() ? negativeCapability : this.positiveBlockInfo.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> negativeCapability = this.negativeBlockInfo.getCapability(cap, side);
        return negativeCapability.isPresent() ? negativeCapability : this.positiveBlockInfo.getCapability(cap, side);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DynamicSlabBakedModel.NEGATIVE_BLOCK, (Object)this.negativeBlockInfo).withInitial(DynamicSlabBakedModel.POSITIVE_BLOCK, (Object)this.positiveBlockInfo).build();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            if (this.positiveBlockInfo.getTileEntity() != null && this.positiveBlockInfo.getTileEntity() instanceof ITickableTileEntity) {
                if (this.positiveBlockInfo.getTileEntity().func_145831_w() == null) {
                    this.positiveBlockInfo.getTileEntity().func_226984_a_(this.positiveBlockInfo.getWorld(), this.positiveBlockInfo.getPos());
                }
                ((ITickableTileEntity)this.positiveBlockInfo.getTileEntity()).func_73660_a();
            }
            if (this.negativeBlockInfo.getTileEntity() != null && this.negativeBlockInfo.getTileEntity() instanceof ITickableTileEntity) {
                if (this.negativeBlockInfo.getTileEntity().func_145831_w() == null) {
                    this.negativeBlockInfo.getTileEntity().func_226984_a_(this.negativeBlockInfo.getWorld(), this.negativeBlockInfo.getPos());
                }
                ((ITickableTileEntity)this.negativeBlockInfo.getTileEntity()).func_73660_a();
            }
        }
    }
}

