/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.init;

import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import cjminecraft.doubleslabs.common.network.PacketHandler;
import cjminecraft.doubleslabs.common.network.packet.config.UpdateServerPlayerConfigPacket;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="doubleslabs", value={Dist.CLIENT})
public class DSKeyBindings {
    private static final List<Pair<KeyBinding, Runnable>> KEYBINDINGS = new LinkedList<Pair<KeyBinding, Runnable>>();

    public static void register() {
        for (Pair<KeyBinding, Runnable> keybind : KEYBINDINGS) {
            ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)keybind.getKey()));
        }
    }

    private static Pair<KeyBinding, Runnable> makeKeybind(String name, int key, Runnable action) {
        KeyBinding keyBinding = new KeyBinding("doubleslabs.key." + name, key, "doubleslabs.keycategory");
        return Pair.of((Object)keyBinding, (Object)action);
    }

    private static void toggleVerticalSlabPlacement() {
        Minecraft.func_71410_x().field_71439_g.getCapability(PlayerConfigCapability.PLAYER_CONFIG).ifPresent(config -> {
            config.setPlaceVerticalSlabs(!config.placeVerticalSlabs());
            PacketHandler.INSTANCE.sendToServer((Object)new UpdateServerPlayerConfigPacket((IPlayerConfig)config));
        });
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Pair<KeyBinding, Runnable> keybind : KEYBINDINGS) {
            if (!((KeyBinding)keybind.getKey()).func_151468_f()) continue;
            ((Runnable)keybind.getValue()).run();
        }
    }

    static {
        KEYBINDINGS.add(DSKeyBindings.makeKeybind("toggleVerticalSlabPlacement", 280, DSKeyBindings::toggleVerticalSlabPlacement));
    }
}

