/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.proxy;

import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.gui.WrappedScreen;
import cjminecraft.doubleslabs.client.model.DoubleSlabBakedModel;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabItemBakedModel;
import cjminecraft.doubleslabs.client.render.RaisedCampfireTileEntityRenderer;
import cjminecraft.doubleslabs.client.render.SlabTileEntityRenderer;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.config.ConfigEventsHandler;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.init.DSContainers;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.init.DSKeyBindings;
import cjminecraft.doubleslabs.common.init.DSTiles;
import cjminecraft.doubleslabs.common.items.VerticalSlabItem;
import cjminecraft.doubleslabs.common.proxy.IProxy;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientProxy
implements IProxy {
    public static final TransformationMatrix RAISED_CAMPFIRE_TRANSFORM = new TransformationMatrix(new Vector3f(0.0f, 0.5f, 0.0f), null, null, null);

    @Override
    public void addListeners(IEventBus mod, IEventBus forge) {
        mod.addListener(this::clientSetup);
        mod.addListener(this::registerBlockColours);
        mod.addListener(this::registerItemColours);
        mod.addListener(this::bakeModels);
        mod.addListener(ConfigEventsHandler::onFileChange);
    }

    private void replaceModel(IBakedModel model, Block block, BiConsumer<IBakedModel, BlockState> perModel, Map<ResourceLocation, IBakedModel> registry) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation variantResourceLocation = BlockModelShapes.func_209554_c((BlockState)state);
            IBakedModel existingModel = registry.get(variantResourceLocation);
            if (existingModel == null) {
                DoubleSlabs.LOGGER.warn("Did not find the expected vanilla baked model(s) for the block in registry");
                continue;
            }
            if (existingModel instanceof DynamicSlabBakedModel) {
                DoubleSlabs.LOGGER.warn("Tried to replace model twice");
                continue;
            }
            perModel.accept(existingModel, state);
            registry.put((ResourceLocation)variantResourceLocation, model);
        }
    }

    private void replaceCampfireModel(Block block, Map<ResourceLocation, IBakedModel> registry, ModelLoader loader) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation variantResourceLocation = BlockModelShapes.func_209554_c((BlockState)state);
            IUnbakedModel existingModel = loader.func_209597_a((ResourceLocation)variantResourceLocation);
            registry.put((ResourceLocation)variantResourceLocation, ClientConstants.bake(loader, existingModel, (ResourceLocation)variantResourceLocation, false, (IModelTransform)new SimpleModelTransform(RAISED_CAMPFIRE_TRANSFORM)));
        }
    }

    private void bakeModels(ModelBakeEvent event) {
        ClientConstants.bakeVerticalSlabModels(event.getModelLoader());
        this.replaceModel((IBakedModel)new DoubleSlabBakedModel(), (Block)DSBlocks.DOUBLE_SLAB.get(), (model, state) -> {}, event.getModelRegistry());
        this.replaceModel((IBakedModel)VerticalSlabBakedModel.INSTANCE, (Block)DSBlocks.VERTICAL_SLAB.get(), VerticalSlabBakedModel.INSTANCE::addModel, event.getModelRegistry());
        this.replaceCampfireModel((Block)DSBlocks.RAISED_CAMPFIRE.get(), event.getModelRegistry(), event.getModelLoader());
        this.replaceCampfireModel((Block)DSBlocks.RAISED_SOUL_CAMPFIRE.get(), event.getModelRegistry(), event.getModelLoader());
        ModList list = ModList.get();
        if (list.isLoaded("endergetic")) {
            this.replaceCampfireModel((Block)DSBlocks.RAISED_ENDER_CAMPFIRE.get(), event.getModelRegistry(), event.getModelLoader());
        }
        if (list.isLoaded("byg")) {
            this.replaceCampfireModel((Block)DSBlocks.RAISED_BORIC_CAMPFIRE.get(), event.getModelRegistry(), event.getModelLoader());
            this.replaceCampfireModel((Block)DSBlocks.RAISED_CRYPTIC_CAMPFIRE.get(), event.getModelRegistry(), event.getModelLoader());
        }
        if (list.isLoaded("infernalexp")) {
            this.replaceCampfireModel((Block)DSBlocks.RAISED_GLOW_CAMPFIRE.get(), event.getModelRegistry(), event.getModelLoader());
        }
        ModelResourceLocation verticalSlabItemResourceLocation = new ModelResourceLocation(DSItems.VERTICAL_SLAB.getId(), "inventory");
        VerticalSlabItemBakedModel.INSTANCE = new VerticalSlabItemBakedModel((IBakedModel)event.getModelRegistry().get(verticalSlabItemResourceLocation));
        event.getModelRegistry().put(verticalSlabItemResourceLocation, VerticalSlabItemBakedModel.INSTANCE);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DSKeyBindings.register();
        RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.DOUBLE_SLAB.get()), layer -> true);
        RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.VERTICAL_SLAB.get()), layer -> true);
        RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.RAISED_CAMPFIRE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.RAISED_SOUL_CAMPFIRE.get()), (RenderType)RenderType.func_228643_e_());
        ModList list = ModList.get();
        if (list.isLoaded("endergetic")) {
            RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.RAISED_ENDER_CAMPFIRE.get()), (RenderType)RenderType.func_228643_e_());
        }
        if (list.isLoaded("byg")) {
            RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.RAISED_BORIC_CAMPFIRE.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.RAISED_CRYPTIC_CAMPFIRE.get()), (RenderType)RenderType.func_228643_e_());
        }
        if (list.isLoaded("infernalexp")) {
            RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.RAISED_GLOW_CAMPFIRE.get()), (RenderType)RenderType.func_228643_e_());
        }
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)DSTiles.DYNAMIC_SLAB.get()), SlabTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)DSTiles.CAMPFIRE.get()), RaisedCampfireTileEntityRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)DSContainers.WRAPPED_CONTAINER.get()), WrappedScreen::new);
    }

    private void registerBlockColours(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(((DynamicSlabBlock)DSBlocks.DOUBLE_SLAB.get()).getBlockColor(), new Block[]{(Block)DSBlocks.DOUBLE_SLAB.get()});
        event.getBlockColors().func_186722_a(((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).getBlockColor(), new Block[]{(Block)DSBlocks.VERTICAL_SLAB.get()});
    }

    private void registerItemColours(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a(((VerticalSlabItem)DSItems.VERTICAL_SLAB.get()).getItemColor(), new IItemProvider[]{(IItemProvider)DSItems.VERTICAL_SLAB.get()});
    }
}

