/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class DoubleSlabBakedModel
extends DynamicSlabBakedModel {
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (extraData.hasProperty(POSITIVE_BLOCK) && extraData.hasProperty(NEGATIVE_BLOCK)) {
            IHorizontalSlabSupport horizontalSlabSupport;
            boolean shouldCull;
            IBlockInfo positiveBlock = (IBlockInfo)extraData.getData(POSITIVE_BLOCK);
            IBlockInfo negativeBlock = (IBlockInfo)extraData.getData(NEGATIVE_BLOCK);
            assert (positiveBlock != null);
            assert (negativeBlock != null);
            BlockState positiveState = positiveBlock.getBlockState();
            BlockState negativeState = negativeBlock.getBlockState();
            if (positiveState == null || negativeState == null) {
                return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData);
            }
            boolean renderHalves = extraData.hasProperty(RENDER_POSITIVE) && extraData.getData(RENDER_POSITIVE) != null;
            boolean renderPositive = renderHalves && (Boolean)extraData.getData(RENDER_POSITIVE) != false;
            boolean topTransparent = ClientConstants.isTransparent(positiveState);
            boolean bottomTransparent = ClientConstants.isTransparent(negativeState);
            boolean bl = shouldCull = !(positiveBlock.getSupport() != null && !positiveBlock.getSupport().shouldCull(positiveState, negativeState) || negativeBlock.getSupport() != null && !negativeBlock.getSupport().shouldCull(negativeState, positiveState) || !DSConfig.CLIENT.shouldCull(positiveState.func_177230_c()) || !DSConfig.CLIENT.shouldCull(negativeState.func_177230_c()) || topTransparent && bottomTransparent && (positiveState.func_177230_c() != negativeState.func_177230_c() || !positiveState.func_203425_a(negativeState.func_177230_c())));
            if (DoubleSlabBakedModel.useDoubleSlabModel(positiveState, negativeState) && (horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((IBlockReader)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState)) != null && horizontalSlabSupport.useDoubleSlabModel(positiveState)) {
                BlockState doubleState = horizontalSlabSupport.getStateForHalf((IBlockReader)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState, SlabType.DOUBLE);
                if (RenderTypeLookup.canRenderInLayer((BlockState)doubleState, (RenderType)MinecraftForgeClient.getRenderLayer()) || MinecraftForgeClient.getRenderLayer() == null) {
                    IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(doubleState);
                    return model.getQuads(doubleState, side, rand, (IModelData)EmptyModelData.INSTANCE);
                }
                return Lists.newArrayList();
            }
            ArrayList quads = Lists.newArrayList();
            if (!(renderHalves && !renderPositive || !RenderTypeLookup.canRenderInLayer((BlockState)positiveState, (RenderType)MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                List<BakedQuad> topQuads = this.getQuadsForState(positiveBlock, side, rand);
                if (shouldCull && (!bottomTransparent && !topTransparent || topTransparent && !bottomTransparent || topTransparent && bottomTransparent)) {
                    topQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == Direction.DOWN);
                }
                quads.addAll(topQuads);
            }
            if (!(renderHalves && renderPositive || !RenderTypeLookup.canRenderInLayer((BlockState)negativeState, (RenderType)MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                List<BakedQuad> bottomQuads = this.getQuadsForState(negativeBlock, side, rand);
                if (shouldCull && (!topTransparent && !bottomTransparent || bottomTransparent && !topTransparent || topTransparent && bottomTransparent)) {
                    bottomQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == Direction.UP);
                }
                quads.addAll(bottomQuads);
            }
            return quads;
        }
        if (MinecraftForgeClient.getRenderLayer() == null) {
            // empty if block
        }
        return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData);
    }
}

