/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.stairwaytoaether;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

@SlabSupportProvider(modid="stairway")
public class StairwayToAetherSlabSupport<T extends Enum<T>>
implements IHorizontalSlabSupport,
IVerticalSlabSupport {
    private final Class<?> slab;
    private final EnumProperty<T> typeProperty;
    private final T[] slabTypes;

    public StairwayToAetherSlabSupport() {
        Enum[] slabTypes;
        EnumProperty typeProperty;
        Class<?> slab;
        try {
            slab = Class.forName("mod.stairway.blocks.BlockSlabs");
            typeProperty = (EnumProperty)slab.getField("TYPE").get(null);
            Class<?> slabType = Class.forName("mod.stairway.blocks.BlockSlabs$EnumBlockHalf");
            slabTypes = (Enum[])slabType.getEnumConstants();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            slab = null;
            typeProperty = null;
            slabTypes = null;
        }
        this.slab = slab;
        this.typeProperty = typeProperty;
        this.slabTypes = slabTypes;
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        return this.slab != null && this.slab.isAssignableFrom(block.getClass());
    }

    @Override
    public boolean isHorizontalSlab(IBlockReader world, BlockPos pos, BlockState state) {
        return this.isHorizontalSlab(state.func_177230_c()) && (((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[0]) || ((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[1]));
    }

    @Override
    public boolean isHorizontalSlab(ItemStack stack, PlayerEntity player, Hand hand) {
        return this.isHorizontalSlab(stack.func_77973_b());
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return this.slab != null && item instanceof BlockItem && this.slab.isAssignableFrom(((BlockItem)item).func_179223_d().getClass());
    }

    @Override
    public boolean isVerticalSlab(IBlockReader world, BlockPos pos, BlockState state) {
        return this.slab != null && this.slab.isAssignableFrom(state.func_177230_c().getClass()) && !((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[0]) && !((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[1]) && !((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[6]);
    }

    @Override
    public boolean isVerticalSlab(ItemStack stack, PlayerEntity player, Hand hand) {
        return this.isHorizontalSlab(stack, player, hand);
    }

    @Override
    public BlockState getStateForDirection(IBlockReader world, BlockPos pos, BlockState state, Direction direction) {
        return this.slab == null ? state : (BlockState)state.func_206870_a(this.typeProperty, this.slabTypes[direction.func_176745_a()]);
    }

    @Override
    public Direction getDirection(IBlockReader world, BlockPos pos, BlockState state) {
        if (this.slab == null) {
            return null;
        }
        Enum type = (Enum)((Object)state.func_177229_b(this.typeProperty));
        if (type.equals(this.slabTypes[2])) {
            return Direction.NORTH;
        }
        if (type.equals(this.slabTypes[3])) {
            return Direction.SOUTH;
        }
        if (type.equals(this.slabTypes[4])) {
            return Direction.EAST;
        }
        return Direction.WEST;
    }

    @Override
    public SlabType getHalf(IBlockReader world, BlockPos pos, BlockState state) {
        if (this.slab == null) {
            return null;
        }
        Enum type = (Enum)((Object)state.func_177229_b(this.typeProperty));
        if (type.equals(this.slabTypes[0])) {
            return SlabType.TOP;
        }
        if (type.equals(this.slabTypes[1])) {
            return SlabType.BOTTOM;
        }
        return SlabType.DOUBLE;
    }

    @Override
    public BlockState getStateForHalf(BlockState state, SlabType half) {
        return this.slab == null ? state : (BlockState)state.func_206870_a(this.typeProperty, this.slabTypes[half == SlabType.TOP ? 0 : 1]);
    }
}

