/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.assorteddecor;

import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import cjminecraft.doubleslabs.api.support.minecraft.MinecraftSlabSupport;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;

@SlabSupportProvider(modid="assorteddecor", priority=1)
public class AssortedDecorColorizerSupport
extends MinecraftSlabSupport {
    @ObjectHolder(value="assorteddecor:colorizer_brush")
    public static final Item COLORIZER_BRUSH = null;
    @ObjectHolder(value="assorteddecor:colorizer_slab")
    public static final Block COLORIZER_SLAB = null;
    private final Class<?> iColorizer;
    private final Method getStoredState;
    private final Method setColorizer;

    public AssortedDecorColorizerSupport() {
        Class<?> icolorizer = null;
        Method getstoredstate = null;
        Method setcolorizer = null;
        try {
            icolorizer = Class.forName("com.grim3212.assorted.decor.common.block.IColorizer");
            getstoredstate = icolorizer.getMethod("getStoredState", IBlockReader.class, BlockPos.class);
            setcolorizer = icolorizer.getMethod("setColorizer", World.class, BlockPos.class, BlockState.class, PlayerEntity.class, Hand.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        this.iColorizer = icolorizer;
        this.getStoredState = getstoredstate;
        this.setColorizer = setcolorizer;
    }

    private static void initCompoundNBT(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new CompoundNBT());
        }
    }

    private static CompoundNBT getTag(ItemStack stack, String keyName) {
        AssortedDecorColorizerSupport.initCompoundNBT(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            AssortedDecorColorizerSupport.putTag(stack, keyName, new CompoundNBT());
        }
        return stack.func_77978_p().func_74775_l(keyName);
    }

    private static void putTag(ItemStack stack, String keyName, CompoundNBT compound) {
        AssortedDecorColorizerSupport.initCompoundNBT(stack);
        stack.func_77978_p().func_218657_a(keyName, (INBT)compound);
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return item instanceof BlockItem && this.iColorizer != null && this.getStoredState != null && this.setColorizer != null && this.iColorizer.isAssignableFrom(((BlockItem)item).func_179223_d().getClass()) && ((BlockItem)item).func_179223_d().equals(COLORIZER_SLAB);
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        return this.iColorizer != null && this.getStoredState != null && this.setColorizer != null && this.iColorizer.isAssignableFrom(block.getClass()) && block.equals(COLORIZER_SLAB);
    }

    @Override
    public ActionResultType onBlockActivated(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b().equals(COLORIZER_BRUSH)) {
            try {
                BlockState stored = NBTUtil.func_190008_d((CompoundNBT)AssortedDecorColorizerSupport.getTag(stack, "stored_state"));
                Object colorizerBlock = this.iColorizer.cast(state.func_177230_c());
                if (this.getStoredState.invoke(colorizerBlock, world, pos) == stored) {
                    return ActionResultType.PASS;
                }
                this.setColorizer.invoke(colorizerBlock, world, pos, stored, player, hand, false);
                SoundType placeSound = stored.getSoundType((IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(player, pos, placeSound.func_185841_e(), SoundCategory.BLOCKS, (placeSound.func_185843_a() + 1.0f) / 2.0f, placeSound.func_185847_b() * 0.8f);
                player.func_184609_a(hand);
                if (!player.func_184812_l_()) {
                    int dmg = stack.func_77952_i() + 1;
                    if (stack.func_77958_k() - dmg <= 0) {
                        player.func_184611_a(hand, new ItemStack((IItemProvider)COLORIZER_BRUSH));
                    } else {
                        stack.func_196085_b(dmg);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.onBlockActivated(state, world, pos, player, hand, hit);
    }
}

