/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.containers.ContainerSupportProvider;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.util.AnnotationUtil;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ContainerSupport {
    private static List<IContainerSupport> containerSupports;

    public static void load() {
        containerSupports = AnnotationUtil.getClassInstances(ContainerSupportProvider.class, IContainerSupport.class, AnnotationUtil.MODID_PREDICATE, Comparator.comparingInt(a -> a.getAnnotationData().getOrDefault("priority", 1000)));
        DoubleSlabs.LOGGER.info("Loaded %s container support classes", (Object)containerSupports.size());
    }

    public static IContainerSupport getSupport(World world, BlockPos pos, BlockState state) {
        if (state.func_177230_c() instanceof IContainerSupport && ((IContainerSupport)state.func_177230_c()).hasSupport(world, pos, state)) {
            return (IContainerSupport)state.func_177230_c();
        }
        for (IContainerSupport support : containerSupports) {
            if (!support.hasSupport(world, pos, state)) continue;
            return support;
        }
        return null;
    }
}

