/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.morerespawnanchors.common.blocks;

import co.eltrut.morerespawnanchors.common.blocks.IRespawnAnchorBlock;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RespawnAnchorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BaseRespawnAnchorBlock
extends Block
implements IRespawnAnchorBlock {
    public BaseRespawnAnchorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_235912_aC_, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public IntegerProperty getCharges() {
        return BlockStateProperties.field_235912_aC_;
    }

    @Override
    public int getMaxCharges() {
        return 4;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ServerPlayerEntity serverplayerentity;
        ItemStack itemstack = player.func_184586_b(handIn);
        if (handIn == Hand.MAIN_HAND && !this.isValidFuel(itemstack) && this.isValidFuel(player.func_184586_b(Hand.OFF_HAND))) {
            return ActionResultType.PASS;
        }
        if (this.isValidFuel(itemstack) && this.notFullyCharged(state)) {
            this.chargeAnchor(worldIn, pos, state);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if ((Integer)state.func_177229_b((Property)this.getCharges()) == 0) {
            return ActionResultType.PASS;
        }
        if (!this.doesRespawnAnchorWork(worldIn)) {
            if (!worldIn.field_72995_K) {
                this.triggerExplosion(state, worldIn, pos);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (!(worldIn.field_72995_K || (serverplayerentity = (ServerPlayerEntity)player).func_241141_L_() == worldIn.func_234923_W_() && serverplayerentity.func_241140_K_().equals((Object)pos))) {
            serverplayerentity.func_242111_a(worldIn.func_234923_W_(), pos, 0.0f, false, true);
            worldIn.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_232819_mt_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.CONSUME;
    }

    public boolean isValidFuel(ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_221695_cJ;
    }

    public boolean notFullyCharged(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getCharges()) < 4;
    }

    @Override
    public boolean doesRespawnAnchorWork(World world) {
        return RespawnAnchorBlock.func_235562_a_((World)world);
    }

    @Override
    public void chargeAnchor(World world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)this.getCharges(), (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)this.getCharges()) + 1)), 3);
        world.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_232817_mr_, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World worldIn, BlockPos pos) {
        return RespawnAnchorBlock.func_235565_a_((BlockState)state, (int)15);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private void triggerExplosion(BlockState state, World world, final BlockPos pos2) {
        world.func_217377_a(pos2, false);
        boolean flag = Direction.Plane.HORIZONTAL.func_239636_a_().map(arg_0 -> ((BlockPos)pos2).func_177972_a(arg_0)).anyMatch(posIn -> RespawnAnchorBlock.func_235566_a_((BlockPos)posIn, (World)world));
        final boolean flag1 = flag || world.func_204610_c(pos2.func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a);
        ExplosionContext explosioncontext = new ExplosionContext(){

            public Optional<Float> func_230312_a_(Explosion explosion, IBlockReader reader, BlockPos pos, BlockState state, FluidState fluid) {
                return pos.equals((Object)pos2) && flag1 ? Optional.of(Float.valueOf(Blocks.field_150355_j.func_149638_a())) : super.func_230312_a_(explosion, reader, pos, state, fluid);
            }
        };
        world.func_230546_a_((Entity)null, DamageSource.func_233546_a_(), explosioncontext, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((Property)this.getCharges()) != 0) {
            if (rand.nextInt(100) == 0) {
                worldIn.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_232816_mq_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            double d0 = (double)pos.func_177958_n() + 0.5 + (0.5 - rand.nextDouble());
            double d1 = (double)pos.func_177956_o() + 1.0;
            double d2 = (double)pos.func_177952_p() + 0.5 + (0.5 - rand.nextDouble());
            double d3 = (double)rand.nextFloat() * 0.04;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_239819_as_, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.getCharges()});
    }
}

