/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mixin.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.quark.content.management.module.ItemSharingModule;
import vazkii.quark.content.tools.module.ColorRunesModule;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Inject(method={"renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/ItemCameraTransforms$TransformType;ZLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;IILnet/minecraft/client/renderer/model/IBakedModel;)V"}, at={@At(value="HEAD")})
    private void setColorRuneTargetStack(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn, CallbackInfo callbackInfo) {
        ColorRunesModule.setTargetStack(itemStackIn);
    }

    @Redirect(method={"getArmorVertexBuilder"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;getArmorGlint()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getArmorGlint() {
        return ColorRunesModule.getArmorGlint();
    }

    @Redirect(method={"getArmorVertexBuilder"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;getArmorEntityGlint()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getArmorEntityGlint() {
        return ColorRunesModule.getArmorEntityGlint();
    }

    @Redirect(method={"getBuffer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;getGlint()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getGlint() {
        return ColorRunesModule.getGlint();
    }

    @Redirect(method={"getBuffer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;getEntityGlint()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getEntityGlint() {
        return ColorRunesModule.getEntityGlint();
    }

    @Redirect(method={"getEntityGlintVertexBuilder"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;getGlintDirect()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getGlintDirect() {
        return ColorRunesModule.getGlintDirect();
    }

    @Redirect(method={"getEntityGlintVertexBuilder"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;getEntityGlintDirect()Lnet/minecraft/client/renderer/RenderType;"))
    private static RenderType getEntityGlintDirect() {
        return ColorRunesModule.getEntityGlintDirect();
    }

    @Accessor
    public abstract ItemColors getItemColors();

    @Inject(method={"renderQuads"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderQuads(MatrixStack ms, IVertexBuilder builder, List<BakedQuad> quads, ItemStack stack, int lightmap, int overlay, CallbackInfo ci) {
        if (ItemSharingModule.alphaValue != 1.0f) {
            boolean flag = !stack.func_190926_b();
            MatrixStack.Entry entry = ms.func_227866_c_();
            for (BakedQuad bakedquad : quads) {
                int i = flag && bakedquad.func_178212_b() ? this.getItemColors().func_186728_a(stack, bakedquad.func_178211_c()) : -1;
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                builder.addVertexData(entry, bakedquad, r, g, b, ItemSharingModule.alphaValue, lightmap, overlay, true);
            }
            ci.cancel();
        }
    }
}

