/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallSignBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.state.Property;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class NoteBlockMobSoundsModule
extends QuarkModule {
    public static final Direction[] SKULL_SEARCH_FACINGS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    @Config
    public static boolean enableVocaloid = true;

    @SubscribeEvent
    public void noteBlockPlayed(NoteBlockEvent.Play event) {
        Direction dir;
        BlockPos pos;
        IWorld world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() != Blocks.field_196586_al) {
            return;
        }
        SoundEvent sound = null;
        Direction[] directionArray = MiscUtil.HORIZONTALS;
        int n = directionArray.length;
        for (int i = 0; i < n && (sound = this.getSoundEvent(world, pos, dir = directionArray[i])) == null; ++i) {
        }
        if (sound != null) {
            event.setCanceled(true);
            int note = event.getVanillaNoteId() - 12;
            if (sound.getRegistryName().toString().startsWith("quark:voice")) {
                note += 6;
            }
            float pitch = (float)Math.pow(2.0, (double)note / 12.0);
            world.func_184133_a(null, pos.func_177984_a(), sound, SoundCategory.BLOCKS, 1.0f, pitch);
        }
    }

    public SoundEvent getSoundEvent(IWorld world, BlockPos pos, Direction direction) {
        TileEntity tile;
        BlockPos offPos = pos.func_177972_a(direction);
        BlockState state = world.func_180495_p(offPos);
        Block block = state.func_177230_c();
        if (block instanceof WallSkullBlock && state.func_177229_b((Property)WallSkullBlock.field_196302_a) == direction) {
            if (block == Blocks.field_196701_eL) {
                return SoundEvents.field_187854_fc;
            }
            if (block == Blocks.field_196704_eN) {
                return SoundEvents.field_190036_ha;
            }
            if (block == Blocks.field_196707_eP) {
                return SoundEvents.field_187899_gZ;
            }
            if (block == Blocks.field_196712_eT) {
                return SoundEvents.field_187572_ar;
            }
            if (block == Blocks.field_196715_eV) {
                return SoundEvents.field_187521_aK;
            }
        }
        if (enableVocaloid && block instanceof WallSignBlock && state.func_177229_b((Property)WallSignBlock.field_176412_a) == direction && (tile = world.func_175625_s(offPos)) instanceof SignTileEntity) {
            SignTileEntity sign = (SignTileEntity)tile;
            String s = sign.field_145915_a[0].getString().trim();
            SoundEvent event = QuarkSounds.VOCAL_EVENTS.get(s);
            if (event != null) {
                return event;
            }
        }
        return null;
    }
}

