/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.config.CostSensitiveEntitySpawnConfig;
import vazkii.quark.base.world.config.EntitySpawnConfig;
import vazkii.quark.base.world.config.StrictBiomeConfig;
import vazkii.quark.content.mobs.client.render.SoulBeadRenderer;
import vazkii.quark.content.mobs.client.render.WraithRenderer;
import vazkii.quark.content.mobs.entity.SoulBeadEntity;
import vazkii.quark.content.mobs.entity.WraithEntity;
import vazkii.quark.content.mobs.item.SoulBeadItem;

@LoadModule(category=ModuleCategory.MOBS)
public class WraithModule
extends QuarkModule {
    public static EntityType<WraithEntity> wraithType;
    public static EntityType<SoulBeadEntity> soulBeadType;
    @Config(description="List of sound sets to use with wraiths.\nThree sounds must be provided per entry, separated by | (in the format idle|hurt|death). Leave blank for no sound (i.e. if a mob has no ambient noise)")
    private static List<String> wraithSounds;
    @Config
    public static EntitySpawnConfig spawnConfig;
    public static ITag<Block> wraithSpawnableTag;
    public static List<String> validWraithSounds;

    @Override
    public void construct() {
        new SoulBeadItem(this);
        wraithType = EntityType.Builder.func_220322_a(WraithEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new WraithEntity((EntityType<? extends WraithEntity>)wraithType, (World)world)).func_206830_a("wraith");
        RegistryHelper.register(wraithType, (String)"wraith");
        soulBeadType = EntityType.Builder.func_220322_a(SoulBeadEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.0f, 0.0f).func_233606_a_(4).func_233608_b_(10).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new SoulBeadEntity((EntityType<? extends SoulBeadEntity>)soulBeadType, (World)world)).func_206830_a("soul_bead");
        RegistryHelper.register(soulBeadType, (String)"soul_bead");
        EntitySpawnHandler.registerSpawn(this, wraithType, EntityClassification.MONSTER, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c, spawnConfig);
        EntitySpawnHandler.addEgg(wraithType, 0xECECEC, 0xBDBDBD, spawnConfig);
    }

    @Override
    public void setup() {
        GlobalEntityTypeAttributes.put(wraithType, (AttributeModifierMap)WraithEntity.registerAttributes().func_233813_a_());
        wraithSpawnableTag = BlockTags.createOptional((ResourceLocation)new ResourceLocation("quark", "wraith_spawnable"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(wraithType, WraithRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(soulBeadType, SoulBeadRenderer::new);
    }

    @Override
    public void configChanged() {
        validWraithSounds = wraithSounds.stream().filter(s -> s.split("\\|").length == 3).collect(Collectors.toList());
    }

    static {
        wraithSounds = Lists.newArrayList((Object[])new String[]{"entity.sheep.ambient|entity.sheep.hurt|entity.sheep.death", "entity.cow.ambient|entity.cow.hurt|entity.cow.death", "entity.pig.ambient|entity.pig.hurt|entity.pig.death", "entity.chicken.ambient|entity.chicken.hurt|entity.chicken.death", "entity.horse.ambient|entity.horse.hurt|entity.horse.death", "entity.cat.ambient|entity.cat.hurt|entity.cat.death", "entity.wolf.ambient|entity.wolf.hurt|entity.wolf.death", "entity.villager.ambient|entity.villager.hurt|entity.villager.death", "entity.polar_bear.ambient|entity.polar_bear.hurt|entity.polar_bear.death", "entity.zombie.ambient|entity.zombie.hurt|entity.zombie.death", "entity.skeleton.ambient|entity.skeleton.hurt|entity.skeleton.death", "entity.spider.ambient|entity.spider.hurt|entity.spider.death", "|entity.creeper.hurt|entity.creeper.death", "entity.endermen.ambient|entity.endermen.hurt|entity.endermen.death", "entity.zombie_pig.ambient|entity.zombie_pig.hurt|entity.zombie_pig.death", "entity.witch.ambient|entity.witch.hurt|entity.witch.death", "entity.blaze.ambient|entity.blaze.hurt|entity.blaze.death", "entity.llama.ambient|entity.llama.hurt|entity.llama.death", "|quark:entity.stoneling.cry|quark:entity.stoneling.die", "quark:entity.frog.idle|quark:entity.frog.hurt|quark:entity.frog.die"});
        spawnConfig = new CostSensitiveEntitySpawnConfig(8, 1, 3, 0.7, 0.15, new StrictBiomeConfig(false, "minecraft:soul_sand_valley"));
    }
}

