/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.block.VariantChestBlock;
import vazkii.quark.content.building.block.VariantTrappedChestBlock;
import vazkii.quark.content.building.client.render.VariantChestTileEntityRenderer;
import vazkii.quark.content.building.recipe.MixedChestRecipe;
import vazkii.quark.content.building.tile.VariantChestTileEntity;
import vazkii.quark.content.building.tile.VariantTrappedChestTileEntity;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true)
public class VariantChestsModule
extends QuarkModule {
    private static final Pattern VILLAGE_PIECE_PATTERN = Pattern.compile("\\w+\\[\\w+\\[([a-z_]+)\\:village\\/(.+?)\\/.+\\]\\]");
    private static final String DONK_CHEST = "Quark:DonkChest";
    private static final ImmutableSet<String> OVERWORLD_WOODS = ImmutableSet.copyOf((Object[])MiscUtil.OVERWORLD_WOOD_TYPES);
    private static final ImmutableSet<String> NETHER_WOODS = ImmutableSet.copyOf((Object[])MiscUtil.NETHER_WOOD_TYPES);
    private static final ImmutableSet<String> MOD_WOODS = ImmutableSet.of();
    public static TileEntityType<VariantChestTileEntity> chestTEType;
    public static TileEntityType<VariantTrappedChestTileEntity> trappedChestTEType;
    private static List<Supplier<Block>> chestTypes;
    private static List<Supplier<Block>> trappedChestTypes;
    private static List<Block> allChests;
    private static Map<String, Block> chestMappings;
    private static Structure<?> currentStructure;
    private static List<StructurePiece> currentComponents;
    @Config
    private static boolean replaceWorldgenChests;
    private static boolean staticEnabled;
    @Config(description="Chests to put in each structure. The format per entry is \"structure=chest\", where \"structure\" is a structure ID, and \"chest\" is a block ID, which must correspond to a standard chest block.")
    public static List<String> structureChests;
    private static final ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;

    @Override
    public void construct() {
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)MixedChestRecipe.SERIALIZER);
        OVERWORLD_WOODS.forEach(s -> this.addChest((String)s, Blocks.field_150486_ae));
        NETHER_WOODS.forEach(s -> this.addChest((String)s, Blocks.field_150486_ae));
        MOD_WOODS.forEach(s -> this.addModChest((String)s, Blocks.field_150486_ae));
        this.addChest("nether_brick", Blocks.field_196653_dH);
        this.addChest("purpur", Blocks.field_185767_cT);
        this.addChest("prismarine", Blocks.field_180397_cI);
        this.addChest("mushroom", Blocks.field_150419_aX);
        chestTEType = VariantChestsModule.registerChests(VariantChestTileEntity::new, chestTypes);
        trappedChestTEType = VariantChestsModule.registerChests(VariantTrappedChestTileEntity::new, trappedChestTypes);
        RegistryHelper.register(chestTEType, (String)"variant_chest");
        RegistryHelper.register(trappedChestTEType, (String)"variant_trapped_chest");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        ClientRegistry.bindTileEntityRenderer(chestTEType, VariantChestTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(trappedChestTEType, VariantChestTileEntityRenderer::new);
    }

    @Override
    public void configChanged() {
        super.configChanged();
        staticEnabled = this.enabled;
        chestMappings.clear();
        for (String s : structureChests) {
            String[] toks = s.split("=");
            if (toks.length != 2) continue;
            String left = toks[0];
            String right = toks[1];
            Registry.field_212618_g.func_241873_b(new ResourceLocation(right)).ifPresent(block -> {
                if (block != Blocks.field_150350_a) {
                    chestMappings.put(left, (Block)block);
                }
            });
        }
    }

    public static void setActiveStructure(Structure<?> structure, List<StructurePiece> components) {
        currentStructure = structure;
        currentComponents = components;
    }

    public static BlockState getGenerationChestBlockState(BlockState current) {
        if (replaceWorldgenChests && current.func_177230_c() == Blocks.field_150486_ae && currentStructure != null && staticEnabled) {
            Block block;
            BlockState placeState;
            LegacySingleJigsawPiece legacyJigsaw;
            String type;
            Matcher match;
            AbstractVillagePiece avp;
            JigsawPiece jigsaw;
            StructurePiece first;
            ResourceLocation res = currentStructure.getRegistryName();
            if (res == null) {
                return current;
            }
            String name = res.toString();
            if ("minecraft:village".equals(name) && currentComponents != null && currentComponents.size() > 0 && (first = currentComponents.get(0)) instanceof AbstractVillagePiece && (jigsaw = (avp = (AbstractVillagePiece)first).func_214826_b()) instanceof LegacySingleJigsawPiece && (match = VILLAGE_PIECE_PATTERN.matcher(type = (legacyJigsaw = (LegacySingleJigsawPiece)jigsaw).toString())).matches()) {
                String namespace = match.group(1);
                String villageType = match.group(2);
                name = name + "_" + villageType;
                if (!namespace.equals("minecraft")) {
                    name = name.replace("minecraft\\:", namespace);
                }
            }
            if (chestMappings.containsKey(name) && (placeState = (block = chestMappings.get(name)).func_176223_P()).func_235904_r_().contains(ChestBlock.field_196314_b)) {
                placeState = (BlockState)((BlockState)((BlockState)placeState.func_206870_a((Property)ChestBlock.field_176459_a, current.func_177229_b((Property)ChestBlock.field_176459_a))).func_206870_a((Property)ChestBlock.field_196314_b, current.func_177229_b((Property)ChestBlock.field_196314_b))).func_206870_a((Property)ChestBlock.field_204511_c, current.func_177229_b((Property)ChestBlock.field_204511_c));
                return placeState;
            }
        }
        return current;
    }

    private void addChest(String name, Block from) {
        this.addChest(name, AbstractBlock.Properties.func_200950_a((AbstractBlock)from));
    }

    private void addChest(String name, AbstractBlock.Properties props) {
        chestTypes.add((Supplier<Block>)((Supplier)() -> new VariantChestBlock(name, this, (Supplier<TileEntityType<? extends ChestTileEntity>>)((Supplier)() -> chestTEType), props)));
        trappedChestTypes.add((Supplier<Block>)((Supplier)() -> new VariantTrappedChestBlock(name, this, (Supplier<TileEntityType<? extends ChestTileEntity>>)((Supplier)() -> trappedChestTEType), props)));
    }

    private void addModChest(String nameRaw, Block from) {
        String[] toks = nameRaw.split(":");
        String name = toks[1];
        String mod = toks[0];
        this.addModChest(name, mod, AbstractBlock.Properties.func_200950_a((AbstractBlock)from));
    }

    private void addModChest(String name, String mod, AbstractBlock.Properties props) {
        chestTypes.add((Supplier<Block>)((Supplier)() -> new VariantChestBlock.Compat(name, mod, this, (Supplier<TileEntityType<? extends ChestTileEntity>>)((Supplier)() -> chestTEType), props)));
        trappedChestTypes.add((Supplier<Block>)((Supplier)() -> new VariantTrappedChestBlock.Compat(name, mod, this, (Supplier<TileEntityType<? extends ChestTileEntity>>)((Supplier)() -> trappedChestTEType), props)));
    }

    public static <T extends TileEntity> TileEntityType<T> registerChests(Supplier<? extends T> factory, List<Supplier<Block>> list) {
        List<Block> blockTypes = list.stream().map(Supplier::get).collect(Collectors.toList());
        allChests.addAll(blockTypes);
        return TileEntityType.Builder.func_223042_a(factory, (Block[])blockTypes.toArray(new Block[blockTypes.size()])).func_206865_a(null);
    }

    @Override
    public void textureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().toString().equals("minecraft:textures/atlas/chest.png")) {
            for (Block b : allChests) {
                VariantChestTileEntityRenderer.accept(event, b);
            }
        }
    }

    @SubscribeEvent
    public void onClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        AbstractChestedHorseEntity horse;
        Entity target = event.getTarget();
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (!held.func_190926_b() && target instanceof AbstractChestedHorseEntity && !(horse = (AbstractChestedHorseEntity)target).func_190695_dh() && held.func_77973_b() != Items.field_221675_bZ && held.func_77973_b().func_206844_a((ITag)Tags.Items.CHESTS_WOODEN)) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            if (!target.field_70170_p.field_72995_K) {
                ItemStack copy = held.func_77946_l();
                copy.func_190920_e(1);
                held.func_190918_g(1);
                horse.getPersistentData().func_218657_a(DONK_CHEST, (INBT)copy.serializeNBT());
                horse.func_110207_m(true);
                horse.func_110226_cD();
                horse.func_190697_dk();
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        AbstractChestedHorseEntity horse;
        ItemStack chest;
        LivingEntity target = event.getEntityLiving();
        if (target instanceof AbstractChestedHorseEntity && !(chest = ItemStack.func_199557_a((CompoundNBT)(horse = (AbstractChestedHorseEntity)target).getPersistentData().func_74775_l(DONK_CHEST))).func_190926_b() && horse.func_190695_dh()) {
            WAIT_TO_REPLACE_CHEST.set(chest);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity target = event.getEntity();
        if (target instanceof ItemEntity && ((ItemEntity)target).func_92059_d().func_77973_b() == Items.field_221675_bZ) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.func_190926_b()) {
                ((ItemEntity)target).func_92058_a(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    static {
        chestTypes = new LinkedList<Supplier<Block>>();
        trappedChestTypes = new LinkedList<Supplier<Block>>();
        allChests = new LinkedList<Block>();
        chestMappings = new HashMap<String, Block>();
        replaceWorldgenChests = true;
        staticEnabled = false;
        structureChests = Arrays.asList("minecraft:village_plains=quark:oak_chest", "minecraft:igloo=quark:spruce_chest", "minecraft:village_snowy=quark:spruce_chest", "minecraft:village_taiga=quark:spruce_chest", "minecraft:desert_pyramid=quark:birch_chest", "minecraft:jungle_pyramid=quark:jungle_chest", "minecraft:village_desert=quark:jungle_chest", "minecraft:village_savanna=quark:acacia_chest", "minecraft:mansion=quark:dark_oak_chest", "minecraft:pillager_outpost=quark:dark_oak_chest", "minecraft:ruined_portal=quark:crimson_chest", "minecraft:bastion_remnant=quark:crimson_chest", "minecraft:fortress=quark:nether_brick_chest", "minecraft:endcity=quark:purpur_chest", "bettermineshafts:mineshaft=quark:oak_chest", "cobbler:shulker_factory=quark:purpur_chest", "conjurer_illager:theatre=quark:dark_oak_chest", "dungeoncrawl:dungeon=quark:oak_chest", "dungeons_plus:bigger_dungeon=quark:oak_chest", "dungeons_plus:end_ruins=quark:purpur_chest", "dungeons_plus:leviathan=quark:jungle_chest", "dungeons_plus:snowy_temple=quark:spruce_chest", "dungeons_plus:soul_prison=quark:warped_chest", "dungeons_plus:tower=quark:oak_chest", "dungeons_plus:warped_garden=quark:warped__chest", "hunterillager:hunterhouse=quark:oak_chest", "iceandfire:gorgon_temple=quark:jungle_chest", "pandoras_creatures:end_prison=quark:purpur_chest", "repurposed_structures:city_nether=quark:nether_brick_chest", "repurposed_structures:fortress_jungle=quark:jungle_chest", "repurposed_structures:igloo_grassy=quark:oak_chest", "repurposed_structures:igloo_stone=quark:spruce_chest", "repurposed_structures:mansion_birch=quark:birch_chest", "repurposed_structures:mansion_desert=quark:jungle_chest", "repurposed_structures:mansion_jungle=quark:jungle_chest", "repurposed_structures:mansion_oak=quark:oak_chest", "repurposed_structures:mansion_savanna=quark:acacia_chest", "repurposed_structures:mansion_snowy=quark:spruce_chest", "repurposed_structures:mansion_taiga=quark:spruce_chest", "repurposed_structures:mineshaft_birch=quark:birch_chest", "repurposed_structures:mineshaft_crimson=quark:crimson_chest", "repurposed_structures:mineshaft_desert=quark:jungle_chest", "repurposed_structures:mineshaft_end=quark:purpur_chest", "repurposed_structures:mineshaft_icy=quark:spruce_chest", "repurposed_structures:mineshaft_jungle=quark:jungle_chest", "repurposed_structures:mineshaft_nether=quark:nether_brick_chest", "repurposed_structures:mineshaft_ocean=quark:prismarine_chest", "repurposed_structures:mineshaft_savanna=quark:acacia_chest", "repurposed_structures:mineshaft_stone=quark:spruce_chest", "repurposed_structures:mineshaft_swamp_or_dark_forest=quark:dark_oak_chest", "repurposed_structures:mineshaft_taiga=quark:spruce_chest", "repurposed_structures:mineshaft_warped=quark:warped_chest", "repurposed_structures:outpost_badlands=quark:dark_oak_chest", "repurposed_structures:outpost_birch=quark:birch_chest", "repurposed_structures:outpost_crimson=quark:crimson_chest", "repurposed_structures:outpost_desert=quark:jungle_chest", "repurposed_structures:outpost_giant_tree_taiga=quark:spruce_chest", "repurposed_structures:outpost_icy=quark:spruce_chest", "repurposed_structures:outpost_jungle=quark:jungle_chest", "repurposed_structures:outpost_nether_brick=quark:nether_brick_chest", "repurposed_structures:outpost_oak=quark:oak_chest", "repurposed_structures:outpost_snowy=quark:spruce_chest", "repurposed_structures:outpost_taiga=quark:spruce_chest", "repurposed_structures:outpost_warped=quark:warped_chest", "repurposed_structures:pyramid_badlands=quark:dark_oak_chest", "repurposed_structures:pyramid_nether=quark:nether_brick_chest", "repurposed_structures:pyramid_snowy=quark:spruce_chest", "repurposed_structures:ruined_portal_end=quark:purpur_chest", "repurposed_structures:ruins_nether=quark:nether_brick_chest", "repurposed_structures:shipwreck_crimson=quark:crimson_chest", "repurposed_structures:shipwreck_end=quark:purpur_chest", "repurposed_structures:shipwreck_nether_bricks=quark:nether_brick_chest", "repurposed_structures:shipwreck_warped=quark:warped_chest", "repurposed_structures:stronghold_nether=quark:nether_brick_chest", "repurposed_structures:stronghold_stonebrick=quark:oak_chest", "repurposed_structures:temple_nether_basalt=quark:nether_brick_chest", "repurposed_structures:temple_nether_crimson=quark:crimson_chest", "repurposed_structures:temple_nether_soul=quark:warped_chest", "repurposed_structures:temple_nether_warped=quark:warped_chest", "repurposed_structures:temple_nether_wasteland=quark:nether_brick_chest", "repurposed_structures:village_badlands=quark:dark_oak_chest", "repurposed_structures:village_birch=quark:birch_chest", "repurposed_structures:village_crimson=quark:crimson_chest", "repurposed_structures:village_dark_oak=quark:dark_oak_chest", "repurposed_structures:village_giant_taiga=quark:spruce_chest", "repurposed_structures:village_jungle=quark:jungle_chest", "repurposed_structures:village_mountains=quark:spruce_chest", "repurposed_structures:village_oak=quark:oak_chest", "repurposed_structures:village_swamp=quark:oak_chest", "repurposed_structures:village_warped=quark:warped_chest", "valhelsia_structures:castle=quark:spruce_chest", "valhelsia_structures:castle_ruin=quark:oak_chest", "valhelsia_structures:desert_house=quark:spruce_chest", "valhelsia_structures:forge=quark:spruce_chest", "valhelsia_structures:player_house=quark:oak_chest", "valhelsia_structures:small_castle=quark:oak_chest", "valhelsia_structures:small_dungeon=quark:oak_chest", "valhelsia_structures:tower_ruin=quark:spruce_chest");
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
    }

    public static interface IChestTextureProvider {
        public String getChestTexturePath();

        public boolean isTrap();
    }
}

