/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.entity.StoolEntity;
import vazkii.quark.content.building.module.StoolsModule;

public class StoolBlock
extends QuarkBlock
implements IWaterLoggable {
    private static final VoxelShape SHAPE_TOP = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)4.0);
    private static final VoxelShape SHAPE_TOP_BIG = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG_BIG = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG, SHAPE_LEG.func_197751_a(0.75, 0.0, 0.0), SHAPE_LEG.func_197751_a(0.75, 0.0, 0.75), SHAPE_LEG.func_197751_a(0.0, 0.0, 0.75)});
    private static final VoxelShape SHAPE_BIG = VoxelShapes.func_216384_a((VoxelShape)SHAPE_TOP_BIG, (VoxelShape[])new VoxelShape[]{SHAPE_LEG_BIG, SHAPE_LEG_BIG.func_197751_a(0.75, 0.0, 0.0), SHAPE_LEG_BIG.func_197751_a(0.75, 0.0, 0.75), SHAPE_LEG_BIG.func_197751_a(0.0, 0.0, 0.75)});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty BIG = BooleanProperty.func_177716_a((String)"big");
    public static final BooleanProperty SAT_IN = BooleanProperty.func_177716_a((String)"sat_in");

    public StoolBlock(QuarkModule module, DyeColor color) {
        super(color.func_176762_d() + "_stool", module, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)color.func_196055_e()).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BIG, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SAT_IN, (Comparable)Boolean.valueOf(false)));
    }

    public void blockClicked(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((Property)BIG)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BIG, (Comparable)Boolean.valueOf(true)));
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.fixState((World)worldIn, pos, state);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((Property)SAT_IN)).booleanValue() || !worldIn.func_180495_p(pos.func_177984_a()).func_196958_f() || player.func_184187_bx() != null) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        if (!worldIn.field_72995_K) {
            StoolEntity entity = new StoolEntity(StoolsModule.stoolEntity, worldIn);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5);
            worldIn.func_217376_c((Entity)entity);
            player.func_184220_m((Entity)entity);
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SAT_IN, (Comparable)Boolean.valueOf(true)));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.bounceEntity(entityIn);
        }
    }

    private void bounceEntity(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * (double)0.66f * d0, vector3d.field_72449_c);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)BIG) != false ? SHAPE_BIG : SHAPE;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateFor(context.func_195991_k(), context.func_195995_a());
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.fixState(worldIn, pos, state);
    }

    private void fixState(World worldIn, BlockPos pos, BlockState state) {
        BlockState target = this.getStateFor(worldIn, pos);
        if (!target.equals(state)) {
            worldIn.func_175656_a(pos, target);
        }
    }

    private BlockState getStateFor(World world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)BIG, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177984_a()).func_196954_c((IBlockReader)world, pos.func_177984_a()).func_197762_b(Direction.Axis.Y) == 0.0))).func_206870_a((Property)SAT_IN, (Comparable)Boolean.valueOf(world.func_175647_a(StoolEntity.class, new AxisAlignedBB(pos, pos.func_177984_a()).func_186662_g(0.4), e -> e.func_233580_cy_().equals((Object)pos)).size() > 0));
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((Property)SAT_IN) != false ? 15 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, BIG, SAT_IN});
    }
}

