/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import java.util.function.BooleanSupplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.module.HedgesModule;

public class HedgeBlock
extends FenceBlock
implements IQuarkBlock,
IBlockColorProvider {
    private final QuarkModule module;
    final Block leaf;
    private BooleanSupplier enabledSupplier = () -> true;
    public static final BooleanProperty EXTEND = BooleanProperty.func_177716_a((String)"extend");

    public HedgeBlock(QuarkModule module, Block fence, Block leaf) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)fence));
        this.module = module;
        this.leaf = leaf;
        RegistryHelper.registerBlock((Block)this, (String)fence.getRegistryName().func_110623_a().replaceAll("_fence", "_hedge"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78031_c);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)EXTEND, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220111_a(BlockState state, boolean isSideSolid, Direction direction) {
        return state.func_177230_c().func_203417_a(HedgesModule.hedgesTag);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return facing == Direction.UP && (Boolean)state.func_177229_b((Property)field_204514_u) == false && plantable.getPlantType(world, pos) == PlantType.PLAINS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockPos down = blockpos.func_177977_b();
        BlockState downState = iblockreader.func_180495_p(down);
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)EXTEND, (Comparable)Boolean.valueOf(downState.func_177230_c() instanceof HedgeBlock));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)field_204514_u)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.func_206870_a((Property)EXTEND, (Comparable)Boolean.valueOf(facingState.func_177230_c() instanceof HedgeBlock));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{EXTEND});
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getBlockColor() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        BlockState leafState = this.leaf.func_176223_P();
        return (state, world, pos, tintIndex) -> colors.func_228054_a_(leafState, world, pos, tintIndex);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        ItemStack leafStack = new ItemStack((IItemProvider)this.leaf);
        return (stack, tintIndex) -> colors.func_186728_a(leafStack, tintIndex);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public HedgeBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }
}

