/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.config;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.world.config.IBiomeConfig;

public class BiomeTypeConfig
implements IBiomeConfig {
    private final Object mutex = new Object();
    @Config(name="Biome Categories")
    @Config.Restriction(value={"none", "taiga", "extreme_hills", "jungle", "mesa", "plains", "savanna", "icy", "the_end", "beach", "forest", "ocean", "desert", "river", "swamp", "mushroom", "nether"})
    private List<String> categoryStrings;
    @Config
    private boolean isBlacklist;
    private List<Biome.Category> categories;

    public BiomeTypeConfig(boolean isBlacklist, Biome.Category ... categories) {
        this.isBlacklist = isBlacklist;
        this.categoryStrings = new LinkedList<String>();
        for (Biome.Category c : categories) {
            this.categoryStrings.add(c.func_222352_a());
        }
    }

    public BiomeTypeConfig(boolean isBlacklist, String ... categories) {
        this.isBlacklist = isBlacklist;
        this.categoryStrings = new LinkedList<String>();
        this.categoryStrings.addAll(Arrays.asList(categories));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSpawn(ResourceLocation res, Biome.Category category) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.categories == null) {
                this.updateTypes();
            }
            for (Biome.Category c : this.categories) {
                if (!c.equals((Object)category)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReload(ConfigFlagManager flagManager) {
        Object object = this.mutex;
        synchronized (object) {
            this.updateTypes();
        }
    }

    public void updateTypes() {
        this.categories = new LinkedList<Biome.Category>();
        for (String s : this.categoryStrings) {
            Biome.Category category = Biome.Category.func_235103_a_((String)s);
            if (category == null) continue;
            this.categories.add(category);
        }
    }
}

