/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.quark.base.client.config.gui.AbstractQScreen;

@Mod.EventBusSubscriber(modid="quark")
public class MiscUtil {
    public static final ResourceLocation GENERAL_ICONS = new ResourceLocation("quark", "textures/gui/general_icons.png");
    private static final MethodHandle LOOT_TABLE_POOLS;
    private static final MethodHandle LOOT_POOL_ENTRIES;
    public static final Direction[] HORIZONTALS;
    public static final String[] OVERWORLD_VARIANT_WOOD_TYPES;
    public static final String[] OVERWORLD_WOOD_TYPES;
    public static final String[] NETHER_WOOD_TYPES;
    private static int progress;

    public static void addToLootTable(LootTable table, LootEntry entry) {
        List<LootPool> pools = MiscUtil.getPools(table);
        if (!pools.isEmpty()) {
            MiscUtil.getEntries(pools.get(0)).add(entry);
        }
    }

    public static List<LootPool> getPools(LootTable table) {
        try {
            return LOOT_TABLE_POOLS.invokeExact(table);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public static List<LootEntry> getEntries(LootPool pool) {
        try {
            return LOOT_POOL_ENTRIES.invokeExact(pool);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public static void damageStack(PlayerEntity player, Hand hand, ItemStack stack, int dmg) {
        stack.func_222118_a(dmg, (LivingEntity)player, p -> p.func_213334_d(hand));
    }

    public static <T, V> void editFinalField(Class<T> clazz, String fieldName, Object obj, V value) {
        Field f = ObfuscationReflectionHelper.findField(clazz, (String)fieldName);
        MiscUtil.editFinalField(f, obj, value);
    }

    public static <T> void editFinalField(Field f, Object obj, T value) {
        try {
            f.setAccessible(true);
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(obj, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initializeEnchantmentList(Iterable<String> enchantNames, List<Enchantment> enchants) {
        enchants.clear();
        for (String s : enchantNames) {
            Registry.field_212628_q.func_241873_b(new ResourceLocation(s)).ifPresent(enchants::add);
        }
    }

    public static Vector2f getMinecraftAngles(Vector3d direction) {
        direction = direction.func_72432_b();
        double pitch = Math.asin(direction.field_72448_b);
        double yaw = Math.asin(direction.field_72450_a / Math.cos(pitch));
        return new Vector2f((float)(pitch * 180.0 / Math.PI), (float)(-yaw * 180.0 / Math.PI));
    }

    public static boolean isEntityInsideOpaqueBlock(Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        return !entity.field_70145_X && entity.field_70170_p.func_180495_p(pos).func_229980_m_((IBlockReader)entity.field_70170_p, pos);
    }

    public static boolean validSpawnLight(IServerWorld world, BlockPos pos, Random rand) {
        if (world.func_226658_a_(LightType.SKY, pos) > rand.nextInt(32)) {
            return false;
        }
        int light = world.func_201672_e().func_72911_I() ? world.func_205049_d(pos, 10) : world.func_201696_r(pos);
        return light <= rand.nextInt(8);
    }

    public static boolean validSpawnLocation(@Nonnull EntityType<? extends MobEntity> type, @Nonnull IWorld world, SpawnReason reason, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        if (reason == SpawnReason.SPAWNER) {
            return true;
        }
        BlockState state = world.func_180495_p(below);
        return state.func_185904_a() == Material.field_151576_e && state.func_215688_a((IBlockReader)world, below, type);
    }

    public static <T> List<T> massRegistryGet(Collection<String> coll, Registry<T> registry) {
        return coll.stream().map(ResourceLocation::new).map(name -> registry.func_241873_b(name)).filter(Optional::isPresent).map(Optional::get).filter((Predicate<Object>)Predicates.notNull()).collect(Collectors.toList());
    }

    public static void syncTE(TileEntity tile) {
        SUpdateTileEntityPacket packet = tile.func_189518_D_();
        if (packet != null && tile.func_145831_w() instanceof ServerWorld) {
            ((ServerChunkProvider)tile.func_145831_w().func_72863_F()).field_217237_a.func_219097_a(new ChunkPos(tile.func_174877_v()), false).forEach(e -> e.field_71135_a.func_147359_a((IPacket)packet));
        }
    }

    public static BlockPos locateBiome(ServerWorld world, ResourceLocation biomeToFind, BlockPos start) {
        Biome biome = (Biome)world.func_73046_m().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_241873_b(biomeToFind).orElseThrow(() -> new RuntimeException("Couldn't find biome " + biomeToFind));
        return world.func_241116_a_(biome, start, 6400, 8);
    }

    public static ItemStack putIntoInv(ItemStack stack, TileEntity tile, Direction face, boolean simulate, boolean doSimulation) {
        IItemHandler handler = null;
        LazyOptional opt = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
        if (opt.isPresent()) {
            handler = (IItemHandler)opt.orElse(null);
        } else if (tile instanceof ISidedInventory) {
            handler = new SidedInvWrapper((ISidedInventory)tile, face);
        } else if (tile instanceof IInventory) {
            handler = new InvWrapper((IInventory)tile);
        }
        if (handler != null) {
            return simulate && !doSimulation ? ItemStack.field_190927_a : ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    public static boolean canPutIntoInv(ItemStack stack, TileEntity tile, Direction face, boolean doSimulation) {
        return MiscUtil.putIntoInv(stack, tile, face, true, doSimulation).func_190926_b();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onKeystroke(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        String[] ids = new String[]{"-FCYE87P5L0", "mybsDDymrsc", "6a4BWpBJppI", "thpTOAS1Vgg", "ZNcBZM5SvbY", "_qJEoSa3Ie0", "RWeyOyY_puQ", "VBbeuXW8Nko", "LIDe-yTxda0", "BVVfMFS3mgc", "m5qwcYL8a0o", "UkY8HvgvBJ8", "4K4b9Z9lSwc", "tyInv6RWL0Q", "tIWpr3tHzII", "AFJPFfnzZ7w", "846cjX0ZTrk", "XEOCbFJjRw0", "GEo5bmUKFvI", "b6li05zh3Kg"};
        int[] keys = new int[]{265, 265, 264, 264, 263, 262, 263, 262, 66, 65};
        if (event.getGui() instanceof AbstractQScreen) {
            if (keys[progress] == event.getKeyCode()) {
                if (++progress >= keys.length) {
                    progress = 0;
                    Util.func_110647_a().func_195640_a("https://www.youtube.com/watch?v=" + ids[new Random().nextInt(ids.length)]);
                }
            } else {
                progress = 0;
            }
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Field lootTablePools = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");
        Field lootPoolEntries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
        try {
            LOOT_TABLE_POOLS = lookup.unreflectGetter(lootTablePools);
            LOOT_POOL_ENTRIES = lookup.unreflectGetter(lootPoolEntries);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        OVERWORLD_VARIANT_WOOD_TYPES = new String[]{"spruce", "birch", "jungle", "acacia", "dark_oak"};
        OVERWORLD_WOOD_TYPES = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
        NETHER_WOOD_TYPES = new String[]{"crimson", "warped"};
    }
}

