/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.module.wither.dispenser.WitherSkullDispenseBehavior;
import insane96mcp.progressivebosses.setup.Config;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Misc", description="Handles various small features, such as the explosion")
public class MiscFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> explosionPowerBonusConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> explosionCausesFireAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> fasterBlockBreakingConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> biggerBlockBreakingConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> ignoreWitherProofBlocksConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> witherNetherOnlyConfig;
    public double explosionPowerBonus = 0.5;
    public int explosionCausesFireAtDifficulty = 16;
    public boolean fasterBlockBreaking = true;
    public boolean biggerBlockBreaking = true;
    public boolean ignoreWitherProofBlocks = false;
    public boolean witherNetherOnly = false;
    private boolean behaviourRegistered = false;

    public MiscFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.explosionPowerBonusConfig = Config.builder.comment("How much explosion power (after the invulnerability) will the Wither gain for each difficulty point. Explosion Radius is capped to 13. Base Wither Explosion Power is 7.0. Setting this to 0 will not increase the Wither Explosion Power.").defineInRange("Explosion Power Bonus", this.explosionPowerBonus, 0.0, 4.0);
        this.explosionCausesFireAtDifficultyConfig = Config.builder.comment("At this difficulty the Wither Explosion will cause fire. Set to -1 to disable.").defineInRange("Explosion Causes Fire at Difficulty", this.explosionCausesFireAtDifficulty, -1, Integer.MAX_VALUE);
        this.fasterBlockBreakingConfig = Config.builder.comment("The Wither will no longer wait 1 full second before breaking blocks when he's hit, instead just 0.5s").define("Faster Breaking Blocks", this.fasterBlockBreaking);
        this.biggerBlockBreakingConfig = Config.builder.comment("The Wither will break even blocks below him when hit.").define("Bigger Breaking Blocks", this.biggerBlockBreaking);
        this.ignoreWitherProofBlocksConfig = Config.builder.comment("If true the Wither will break even blocks that are witherproof.").define("Ignore Witherproof Blocks", this.ignoreWitherProofBlocks);
        this.witherNetherOnlyConfig = Config.builder.comment("The wither can only be spawned in the Nether.\nNote that this feature completely disables Wither Skulls from begin placed nearby Soul Sand when not in the Nether or when on the Nether Roof.\nRequires Minecraft restart.").define("Wither Nether Only", this.witherNetherOnly);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.explosionPowerBonus = (Double)this.explosionPowerBonusConfig.get();
        this.explosionCausesFireAtDifficulty = (Integer)this.explosionCausesFireAtDifficultyConfig.get();
        this.fasterBlockBreaking = (Boolean)this.fasterBlockBreakingConfig.get();
        this.biggerBlockBreaking = (Boolean)this.biggerBlockBreakingConfig.get();
        this.witherNetherOnly = (Boolean)this.witherNetherOnlyConfig.get();
        if (this.witherNetherOnly && !this.behaviourRegistered) {
            DispenserBlock.func_199774_a((IItemProvider)Items.field_196183_dw, (IDispenseItemBehavior)new WitherSkullDispenseBehavior());
            this.behaviourRegistered = true;
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.biggerBlockBreaking) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        if (!wither.func_70089_S()) {
            return;
        }
        if (wither.field_82222_j == 1) {
            --wither.field_82222_j;
            if (ForgeEventFactory.getMobGriefingEvent((World)wither.field_70170_p, (Entity)wither)) {
                int i1 = MathHelper.func_76128_c((double)wither.func_226278_cu_());
                int l1 = MathHelper.func_76128_c((double)wither.func_226277_ct_());
                int i2 = MathHelper.func_76128_c((double)wither.func_226281_cx_());
                boolean flag = false;
                int yOffsetLow = -1;
                if (wither.func_225509_J__()) {
                    yOffsetLow = 0;
                }
                for (int k2 = -1; k2 <= 1; ++k2) {
                    for (int l2 = -1; l2 <= 1; ++l2) {
                        for (int j = yOffsetLow; j <= 4; ++j) {
                            int i3 = l1 + k2;
                            int k = i1 + j;
                            int l = i2 + l2;
                            BlockPos blockpos = new BlockPos(i3, k, l);
                            BlockState blockstate = wither.field_70170_p.func_180495_p(blockpos);
                            if (!this.canWitherDestroy(wither, blockpos, blockstate) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)wither, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                            flag = wither.field_70170_p.func_225521_a_(blockpos, true, (Entity)wither) || flag;
                        }
                    }
                }
                if (flag) {
                    wither.field_70170_p.func_217378_a(null, 1022, wither.func_233580_cy_(), 0);
                }
            }
        }
    }

    private boolean canWitherDestroy(WitherEntity wither, BlockPos pos, BlockState state) {
        if (this.ignoreWitherProofBlocks) {
            return !state.func_196958_f() && state.func_185887_b((IBlockReader)wither.field_70170_p, pos) >= 0.0f;
        }
        return state.canEntityDestroy((IBlockReader)wither.field_70170_p, pos, (Entity)wither);
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.explosionCausesFireAtDifficulty == -1 && this.explosionPowerBonus == 0.0) {
            return;
        }
        if (!(event.getExplosion().getExploder() instanceof WitherEntity)) {
            return;
        }
        if (event.getExplosion().field_77280_f != 7.0f) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getExplosion().getExploder();
        CompoundNBT tags = wither.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float explosionPower = (float)((double)event.getExplosion().field_77280_f + this.explosionPowerBonus * (double)difficulty);
        if (explosionPower > 13.0f) {
            explosionPower = 13.0f;
        }
        event.getExplosion().field_77280_f = explosionPower;
        event.getExplosion().field_77286_a = difficulty >= (float)this.explosionCausesFireAtDifficulty;
    }

    @SubscribeEvent
    public void onWitherDamage(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.fasterBlockBreaking) {
            return;
        }
        if (!event.getEntity().func_70089_S()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntityLiving();
        wither.field_82222_j = 10;
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.witherNetherOnly) {
            return;
        }
        if (event.getItemStack().func_77973_b() == Items.field_196183_dw && !MiscFeature.canPlaceSkull(event.getWorld(), event.getPos().func_177971_a(event.getFace().func_176730_m()))) {
            event.setCanceled(true);
        }
    }

    public static boolean canPlaceSkull(World world, BlockPos pos) {
        boolean isNether = world.func_234923_W_().func_240901_a_().equals((Object)DimensionType.field_236000_d_);
        boolean hasSoulSandNearby = false;
        for (Direction dir : Direction.values()) {
            if (!world.func_180495_p(pos.func_177971_a(dir.func_176730_m())).func_177230_c().equals(Blocks.field_150425_aM) && !world.func_180495_p(pos.func_177971_a(dir.func_176730_m())).func_177230_c().equals(Blocks.field_235336_cN_)) continue;
            hasSoulSandNearby = true;
            break;
        }
        return isNether && pos.func_177956_o() <= 127 || !hasSoulSandNearby;
    }
}

